% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.threshold.uncertain.R
\name{quality.threshold.uncertain}
\alias{quality.threshold.uncertain}
\title{Function for the description of the qualities of the Uncertain Interval.}
\usage{
quality.threshold.uncertain(ref, test, threshold, threshold.upper,
  intersection = NULL)
}
\arguments{
\item{ref}{The reference standard. A column in a data frame or a vector indicating the classification by the reference test. The reference standard must be coded either as 0 (absence of the condition) or 1 (presence of the condition)}

\item{test}{The index test or test under evaluation. A column in a dataset or vector indicating the test results in a continuous scale.}

\item{threshold}{The lower decision threshold of a trichotomization method.}

\item{threshold.upper}{The upper decision threshold of a trichotomization method. When NULL, the test scores are dichotomized.}

\item{intersection}{(default = NULL). When NULL, the intersection is calculated with \code{get.intersection}, which uses the kernel density method to obtain the intersection. When another value is assigned to this parameter, this value is used instead.}
}
\value{
{ A list of}
\describe{
  \item{intersection}{The value used as estimate of the intersection. NOTE: The trichotomization method TG-ROC has no defined position for its Intermediate Range, but usage of the point where Sensitivity=Specificity seems a reasonable choice.}
  \item{table}{The confusion table of {diag x ref} for the Uncertain Interval where the scores are expected to be inconclusive, where diag is the diagnosis based on the test, when applying the thresholds. Both the reference standard (ref) and the diagnosis based on the test scores (diag) have categories 0 and 1. In the case of the Uncertain Interval trichotomization method, the row NA shows the count of test scores within the Uncertain Interval. When applying the trichotomization method TG-ROC, the row NA shows the count of the test scores within the Intermediate Range. Table cell {0, 0} shows the True Negatives (TN), cell {0, 1} shows the False Negatives (FN), cell {1, 0} shows the False Positives (FP), and cell {1, 1} shows the True Positives (TP).}
  \item{cut}{The values of the thresholds.}
  \item{X2}{Table with the outcomes of three Chi-square tests of the confusion table:}
    \itemize{
      \item{TN.FP: }{Chi-square test of the comparison of TN versus FP.}
      \item{FN.TP: }{Chi-square test of the comparison of FN versus TP.}
      \item{overall: }{Chi-square test of all four cells of the table.}
      }
     \item{t.test}{Table with t-test results for the comparison of the means. Within the Uncertain Interval, the test scores are compared of individuals without the targeted condition (ref = 0) and individuals with the targeted condition (ref = 1).}
  \item{indices}{A named vector, with the following statistics for the test-scores within the Uncertain Interval:}
    \itemize{
      \item{prevalence: }{Diagnosable patients with the targeted condition / Total diagnosable sample = (TP+FN)/(TN+FP+FN+TP)}
      \item{correct.classification.rate (or Accuracy): }{(TP+TN)/(TN+FP+FN+TP)}
      \item{balance.correct.incorrect: }{(TP+TN)/(FP+FN)}
      \item{specificity: }{TN/(TN+FN)}
      \item{sensitivity: }{TP/(TP+FN)}
      \item{negative.predictive.value: }{TN/(TN+FN)}
      \item{positive.predictive.value: }{TP/(TN+FN)}
      \item{neg.likelihood.ratio: }{(1-sensitivity)/specificity}
      \item{pos.likelihood.ratio: }{sensitivity/(1-specificity)}
  }
  }
}
\description{
This function can be used only for trichotomization (double thresholds or cut-points) methods. In the case of the Uncertain Interval trichotomization method, it provides descriptive statistics for the test scores within the Uncertain Interval. For the TG-ROC trichotomization method it provides the descriptive statistics for TG-ROC's Intermediate Range.
}
\details{
The Uncertain Interval is defined as an interval below and above the intersection, with a sensitivity and specificity below a desired value (default .55). As a result, it is expected that Chi-square tests are not significant, provided that the count of individuals within the Uncertain Interval is not too large. Most often, the t-test is also non-significant, but as the power of the t-test is considerably larger than the power of the Chi-square test, this is less often the case. It is recommended to look at the difference of the means of the two sub-samples and to visually inspect the inter-mixedness of the test scores.

The patients that have test scores within the Uncertain Interval cannot be correctly classified on the basis of their test result. The results within the Uncertain Interval differ only slightly for patients with and without the targeted condition. Patients with slightly lower or higher test scores too often have the opposite status. They receive the diagnostic result 'Uncertain'; it is better to apply additional tests or to await further developments.

TG-ROC's Intermediate Range has no defined central position, although one may use the position where sensitivity equals specificity as a replacement of the intersection.

The best way to compare the results of the Uncertain Interval with the results of TG-ROC's Intermediate range is the t-test, casu quo, their mean differences.
}
\examples{
# A simple test model
ref=c(rep(0,500), rep(1,500))
test=c(rnorm(500,0,1), rnorm(500,1,sd=1))
ua = uncertain.interval(ref, test)
quality.threshold.uncertain(ref, test, ua[1], ua[2])
}

