% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_wrappers.R
\name{BiCop2copula}
\alias{BiCop2copula}
\alias{copulaFromFamilyIndex}
\title{Construction of a Copula Object from a VineCopula Family Index}
\usage{
BiCop2copula(family, par, par2 = 0, obj = NULL)

copulaFromFamilyIndex(family, par, par2 = 0)
}
\arguments{
\item{family}{a family index as defined in \code{\link[=VineCopula-package]{VineCopula-package()}}.}

\item{par}{first parameter.}

\item{par2}{second parameter.}

\item{obj}{\code{\link[=BiCop]{BiCop()}} object containing the family and parameter specification.}
}
\value{
An object inheriting \linkS4class{copula} corresponding to the
specific family.
}
\description{
A VineCopula family index along with its parameters is used to construct a
corresponding \linkS4class{copula} object.
}
\details{
If the family and parameter specification is stored in a \verb{[BiCop()]} object
\code{obj}, the alternative version

\if{html}{\out{<div class="sourceCode">}}\preformatted{BiCop2copula(u1, u2, obj)
}\if{html}{\out{</div>}}

can be used.
}
\examples{
# normalCopula with parameter 0.5
BiCop2copula(1, 0.5)

# rotated Tawn T2 copula
BiCop2copula(224, -2, 0.5)

}
