\name{mix2poisson}
\alias{mix2poisson}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Mixture of Two Poisson Distributions }
\description{
  Estimates the three parameters of a mixture of two Poisson distributions
  by maximum likelihood estimation.

}
\usage{
mix2poisson(lphi = "logit", llambda = "loge",
            ephi=list(), el1=list(), el2=list(),
            iphi = 0.5, il1 = NULL, il2 = NULL,
            qmu = c(0.2, 0.8), nsimEIM=100, zero = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{lphi}{
    Link function for the parameter \eqn{\phi}{phi}.
    See \code{\link{Links}} for more choices.

  }
  \item{llambda}{
    Link function applied to each \eqn{\lambda}{lambda} parameter.
    See \code{\link{Links}} for more choices.

  }
  \item{ephi, el1, el2}{
  List. Extra argument for each of the links.
  See \code{earg} in \code{\link{Links}} for general information.

  }
  \item{iphi}{
  Initial value for \eqn{\phi}{phi}, whose value must lie
  between 0 and 1.

  }
  \item{il1, il2}{
    Optional initial value for \eqn{\lambda_1}{lambda1} and
    \eqn{\lambda_2}{lambda2}. These values must be positive.
    The default is to compute initial values internally using
    the argument \code{qmu}.

  }
  \item{qmu}{
    Vector with two values giving the probabilities relating to the sample
    quantiles for obtaining initial values for \eqn{\lambda_1}{lambda1}
    and \eqn{\lambda_2}{lambda2}.
    The two values are fed in as the \code{probs} argument into
    \code{\link[stats]{quantile}}.

  }
  \item{nsimEIM}{
  See \code{\link{CommonVGAMffArguments}}.

  }
  \item{zero}{
  An integer specifying which linear/additive predictor is modelled as
  intercepts only.  If given, the value must be either 1 and/or 2 and/or
  3, and the default is the first one only, meaning \eqn{\phi}{phi}
  is a single parameter even when there are explanatory variables.
  Set \code{zero=NULL} to model all linear/additive predictors as
  functions of the explanatory variables.
  See \code{\link{CommonVGAMffArguments}} for more information.

  }
}
\details{
  The probability function can be loosely written as 
  \deqn{P(Y=y) = \phi \, Poisson(\lambda_1) + (1-\phi) \, Poisson(\lambda_2)}{%
        P(Y=y) = phi * Poisson(lambda1) + (1-phi) * Poisson(lambda2)}
  where \eqn{\phi}{phi} is the probability an observation belongs
  to the first group, and \eqn{y=0,1,2,\ldots}{y=0,1,2,...}.
  The parameter \eqn{\phi}{phi} satisfies \eqn{0 < \phi < 1}{0 < phi < 1}.
  The mean of \eqn{Y} is
  \eqn{\phi \lambda_1 + (1-\phi) \lambda_2}{phi*lambda1 + (1-phi)*lambda2}
  and this is returned as the fitted values.
  By default, the three linear/additive predictors are
  \eqn{(logit(\phi), \log(\lambda_1), \log(\lambda_2))^T}{(logit(phi),
  log(lambda1), log(lambda2))^T}.

}
\value{
  An object of class \code{"vglmff"} (see \code{\link{vglmff-class}}).
  The object is used by modelling functions such as \code{\link{vglm}}
  and \code{\link{vgam}}.

}
% \references{ ~put references to the literature/web site here ~ }
\section{Warning }{
  This \pkg{VGAM} family function requires care for a successful
  application.
  In particular, good initial values are required because of the presence
  of local solutions. Therefore running this function with several
  different combinations of arguments such as \code{iphi}, \code{il1},
  \code{il2}, \code{qmu} is highly recommended. Graphical methods such
  as \code{\link[graphics]{hist}} can be used as an aid.

  With grouped data (i.e., using the \code{weights} argument)
  one has to use a large value of \code{nsimEIM};
  see the example below.

}

\author{ T. W. Yee }
\note{
  The response must be integer-valued since \code{\link[stats]{dpois}}
  is invoked.

  Fitting this model successfully to data can be difficult due to local
  solutions and ill-conditioned data. It pays to fit the model several
  times with different initial values, and check that the best fit
  looks reasonable. Plotting the results is recommended. This function
  works better as \eqn{\lambda_1}{lambda1} and \eqn{\lambda_2}{lambda2}
  become more different.
  The default control argument \code{trace=TRUE} is to encourage
  monitoring convergence.

}

\seealso{
  \code{\link[stats:Poisson]{rpois}},
  \code{\link{poissonff}},
  \code{\link{mix2normal1}}.
}

\examples{
# Example 1: simulated data
n = 1000
mu1 = exp(2.5) # also known as lambda1
mu2 = exp(3)
(phi = logit(-0.5, inverse=TRUE))
y = ifelse(runif(n) < phi, rpois(n, mu1), rpois(n, mu2))
fit = vglm(y ~ 1, mix2poisson)
coef(fit, matrix=TRUE)

# Compare the results with the truth
round(rbind('Estimated'=Coef(fit), 'Truth'=c(phi, mu1, mu2)), dig=2)

\dontrun{# Plot the results
ty = table(y)
plot(names(ty), ty, type="h", main="Red=estimate, blue=truth",
     ylab="Frequency", xlab="y")
abline(v=Coef(fit)[-1], lty=2, col="red", lwd=2)
abline(v=c(mu1, mu2), lty=2, col="blue", lwd=2)
}

# Example 2: London Times data (Lange, 1997, p.31)
deaths = 0:9
freq = c(162, 267, 271, 185, 111, 61, 27, 8, 3, 1)
y = rep(deaths, freq)

# Usually this does not work well unless nsimEIM is large
fit = vglm(deaths ~ 1, weight = freq,
           mix2poisson(iphi=0.3, il1=1, il2=2.5, nsimEIM=5000))

# This works better in general
fit = vglm(y ~ 1, mix2poisson(iphi=0.3, il1=1, il2=2.5))

coef(fit, matrix=TRUE)
Coef(fit)
}
\keyword{models}
\keyword{regression}


