% file MASS/genotype.d
% copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{genotype}
\alias{genotype}
\title{
Rat Genotype Data
}
\description{
Data from a foster feeding experiment with rat mothers and litters of
four different genotypes: \code{A}, \code{B}, \code{I} and \code{J}.  Rice litters were
separated from their natural mothers at birth and given to foster
mothers to rear.
}
\usage{
data(genotype)
}
\format{
The data frame has the following components:
\describe{
\item{\code{Litter}}{
The genotype of the litter
}
\item{\code{Mother}}{
The genotype of the foster mother
}
\item{\code{Wt}}{
Litter average weight gain of the litter, in grams at age 28 days.
(The source states that the within-litter variability is negligible.)
}}}
\source{
Scheffe, H. (1959)
\emph{The Analysis of Variance}
Wiley p.140


Bailey, D. W. (1953)
\emph{The Inheritance of Maternal Influences on the Growth of the Rat.}
Unpublished Ph.D. thesis, University of California. Table B of the Appendix.
}
\keyword{datasets}
