% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{select_recorded_eye}
\alias{select_recorded_eye}
\title{Select the eye used during recording}
\usage{
select_recorded_eye(data = data, Recording = Recording, WhenLandR = NA)
}
\arguments{
\item{data}{A data table object output by \code{\link{create_time_series}}.}

\item{Recording}{A string indicating which eyes were used for recording gaze data.}

\item{WhenLandR}{A string indicating which eye ("Right" or "Left) to use 
if gaze data is available for both eyes (i.e., Recording = "LandR").}
}
\value{
A data table with four additional columns ('EyeRecorded', 'EyeSelected',
'IA_ID','IA_LABEL') added to \code{data}.
}
\description{
\code{select_recorded_eye} examines each event and determines which eye contains 
interest area information, based on the \code{Recording} parameter (which 
can be determined using \code{\link{check_eye_recording}}). 
This function then selects the data from the recorded eye and copies it
new columns (IA_ID and IA_LABEL). The function prints a summary of output.
}
\examples{
\dontrun{
library(VWPre)
# Create a unified columns for the gaze data...
df <- select_recorded_eye(data = dat, Recording = "LandR", WhenLandR = "Right")
}
}

