% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censlinVarReg.R
\name{censlinVarReg}
\alias{censlinVarReg}
\title{Censored Linear mean and variance regression}
\usage{
censlinVarReg(dat, mean.ind = c(2), var.ind = c(2), cens.ind = c(3),
  mean.intercept = TRUE, para.space = c("all", "positive", "negative"),
  mean.init = NULL, var.init = NULL, control = list(...), ...)
}
\arguments{
\item{dat}{Dataframe containing outcome and covariate data. Outcome data must be in the first column, with censored values set to the limits. Covariates for mean and variance model in next columns.}

\item{mean.ind}{Vector containing the column numbers of the data in 'dat' to be fit as covariates in the mean model. 0 indicates constant mean option. NULL indicates zero mean option.}

\item{var.ind}{Vector containing the column numbers of the data in 'dat' to be fit as covariates in the variance model. FALSE indicates constant variance option.}

\item{cens.ind}{Vector containing the column number of the data in 'dat' to indicate the censored data. 0 indicates no censoring, -1 indicates left (lower) censoring and 1 indicates right (upper) censoring.}

\item{mean.intercept}{Logical to indicate if an intercept is to be included in the mean model. Default is TRUE.}

\item{para.space}{Parameter space to search for variance parameter estimates. "positive" means only search positive parameter space, "negative" means search only negative parameter space and "all" means search all. Default is all.}

\item{mean.init}{Vector of initial estimates to be used for the mean model.}

\item{var.init}{Vector of initial estimates to be used for the variance model.}

\item{control}{List of control parameters. See \code{\link{VarReg.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied
directly}
}
\value{
\code{censlinVarReg} returns a list of output including:
\itemize{
\item\code{converged}: Logical argument indicating if convergence occurred.
\item\code{iterations}: Total iterations performed of the EM algorithm.
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{loglik}: Numeric variable of the maximised log-likelihood.
 \item\code{boundary}: Logical argument indicating if estimates are on the boundary.
 \item\code{aic.c}: Akaike information criterion corrected for small samples
 \item\code{aic}: Akaike information criterion
 \item\code{bic}: Bayesian information criterion
 \item\code{hqc}: Hannan-Quinn information criterion
 \item\code{mean.ind}: Vector of integer(s) indicating the column number(s) in the dataframe
 \code{data} that were fit in the mean model.
 \item\code{mean}: Vector of the maximum likelihood estimates of the mean parameters.
 \item \code{var.ind}: Vector of integer(s) indicating the column(s) in the dataframe
 \code{data} that were fit in the variance model.
 \item\code{variance}: Vector of the maximum likelihood estimates of the variance parameters.
 \item\code{cens.ind}: Integer indicating the column in the dataframe \code{data} that
 corresponds to the censoring indicator.
 \item\code{data}: Dataframe containing the variables included in the model.
 }
}
\description{
\code{censlinVarReg} performs censored multivariate mean and multivariate variance regression.
This function is designed to be used by the  \code{\link{semiVarReg}} function.
}
