% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logarithms.R
\name{04. Logarithms}
\alias{04. Logarithms}
\alias{log10.vli}
\alias{log10rem}
\alias{log10rem.default}
\alias{log10rem.numeric}
\alias{log10rem.vli}
\alias{log.vli}
\alias{logrem}
\alias{logrem.default}
\alias{logrem.numeric}
\alias{logrem.vli}
\alias{loge}
\alias{loge.default}
\alias{loge.numeric}
\alias{loge.vli}
\title{Integer Logarithms for vli Objects}
\usage{
\method{log10}{vli}(x)

log10rem(x)

\method{log10rem}{default}(x)

\method{log10rem}{numeric}(x)

\method{log10rem}{vli}(x)

\method{log}{vli}(x, base)

logrem(x, base)

\method{logrem}{default}(x, base)

\method{logrem}{numeric}(x, base)

\method{logrem}{vli}(x, base)

loge(x)

\method{loge}{default}(x)

\method{loge}{numeric}(x)

\method{loge}{vli}(x)
}
\arguments{
\item{x}{object of class vli or 32 bits integer}

\item{base}{base of the logarithm; object of class vli or 32 bits integer}
}
\value{
object of class vli
}
\description{
Computation of integer logarithms and their remainders for objects of class vli.

Functions \code{log}, \code{log10} and \code{loge} return respectively the integer generalized logarithm, the integer base-10 logarithm and the integer natural logarithm of the given values. Functions \code{logrem} and \code{log10rem} returns the corresponding remainder.
}
\examples{
x <- as.vli("3873899469432")
log(x, base = 5)
logrem(x, base = 5)
( 5^log(x, base = 5) ) + logrem(x, base = 5) == x
x <- as.vli("149234629386497858748773210293261249785")
log10(x)
}
\author{
Javier Leiva Cuadrado
}
