% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primes.R
\name{19. Finding all primes}
\alias{19. Finding all primes}
\alias{primes}
\alias{primes.default}
\alias{primes.numeric}
\alias{primes.vli}
\title{Finding All Primes Up to a Given Bound}
\usage{
primes(n, test = "MR", iter = 10, bar = TRUE)

\method{primes}{default}(n, test = "MR", iter = 10, bar = TRUE)

\method{primes}{numeric}(n, test = "MR", iter = 10, bar = TRUE)

\method{primes}{vli}(n, test = "MR", iter = 10, bar = TRUE)
}
\arguments{
\item{n}{upper bound of the interval in which look for primes; object of class vli or 32 bits}

\item{test}{chosen test for each number: "F" for the Fermat Test, "SS" for the Solovay-Strassen Test or "MR" (by default) for the Miller-Rabin Test; character}

\item{iter}{number of iterations for each number being tested; numeric}

\item{bar}{to choose if display or not a progress bar; boolean}
}
\value{
vector of objects of class "noquote"
}
\description{
The function \code{primes} displays a vector with all prime numbers up to a given bound. Computation can be made by using different probabilistic primality tests at the user's choice (Fermat Test, Miller-Rabin Test or Solovay-Strassen Test). The number of iterations is also configurable, to set the desired accuracy.
}
\examples{
primes(n = 600, iter = 10, test = "MR", bar = TRUE)
}
\author{
Javier Leiva Cuadrado
}
