#' @name intubation
#' @title intubation 
#' @description The dataset called intubation is a sample of SIMULRUN's data. 
#' SIMULRUN is a research project funded by European funds (FEDER) and focusses on learning processes in simulation in healthcare. This set of data 
#' corresponds to an intubation procedure of a new-born resuscitation during a high fidelity simulation.
#' @details The process is composed of three punctual actions and one long action : \itemize{
#' \item{ time_in_intub :} { The time when the blade is in the mouth.}
#' \item{ time_insert_probe :}{ The time when the tube is inserted into the mouth.}
#' \item{ time_out_intub :} { The time when the blade is out of the mouth.}
#' \item{ delay_intub_prob :} { The delay between the time when the blade is in 
#' the mouth and when the tube is inserted into the mouth.}
#' }
#' @docType data
#' @usage intubation
#' @seealso \code{\linkS4class{ViSigrid}} and see \code{\link{plot-ViSigrid-method}} for examples.
NULL
