% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-query.R
\name{vicmap_query}
\alias{vicmap_query}
\title{Establish Vicmap Query}
\usage{
vicmap_query(layer, CRS = 4283, wfs_version = "2.0.0")
}
\arguments{
\item{layer}{vicmap layer to query. Options are listed in \code{listLayers()}}

\item{CRS}{Coordinate Reference System (default is 4283)}

\item{wfs_version}{The current version of WFS is 2.0.0.
GeoServer supports versions 2.0.0, 1.1.0, and 1.0.0.
However in order for filtering to be correctly applied wfs_version must be 2.0.0 (default is 2.0.0)}
}
\value{
object of class \code{vicmap_promise}, which is a 'promise' of the data that can  be returned if \code{collect()} is used
}
\description{
Begin a Vicmap WFS query by selecting a WFS layer. The record must be available as a
Web Feature Service (WFS) layer (listed in \code{listLayers()})
}
\details{
The returned \code{vicmap_promise} object is not data, rather it is a 'promise' of the data that can
be returned if \code{collect()} is used; which returns an \code{sf} object.
}
\examples{
\donttest{
try(
vicmap_query(layer = "open-data-platform:hy_watercourse")
)
}
}
