% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph2simon_etc.R
\name{autoplot.ph2simon}
\alias{autoplot.ph2simon}
\title{Plot Simon's Two-Stage Design}
\usage{
\method{autoplot}{ph2simon}(object, ...)
}
\arguments{
\item{object}{\link[clinfun]{ph2simon} object}

\item{...}{potential parameters, currently not in use}
}
\value{
Function \code{\link[=autoplot.ph2simon]{autoplot.ph2simon()}} returns a \link[ggplot2]{ggplot} object.
}
\description{
Plot \link[clinfun]{ph2simon} object using \CRANpkg{ggplot2}.
}
\examples{
library(clinfun)
(x = ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
class(x)
autoplot(x, type = 'minimax')
autoplot(x, type = 'optimal')
autoplot(x, type = 'n1')
autoplot(x, type = 'maximax')

# example with r1 = 0
(des = ph2simon(pu = .05, pa = .3, ep1 = .05, ep2 = .2))
autoplot(des, type = 'optimal')
autoplot(des, type = 'minimax')

}
