% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noaaParameters.R
\name{noaa.parameters}
\alias{noaa.parameters}
\title{Reports data available for a NOAA station}
\usage{
noaa.parameters(stn = 8467150)
}
\arguments{
\item{stn}{NOAA station number (note that station names are not 
yet acceptable inputs). Default station is Bridgeport, CT.}
}
\value{
a dataframe with parameters and associated start and end 
dates. Where a parameter's availability is not continuous, multiple
 rows are reported. This function can be used to, for example, select 
 meteorological parameters to include in calls to \code{\link{noaa}}
}
\description{
Reports data available for a NOAA station
}
\details{
\code{noaa.parameters} reports the parameters (meteorological 
and tidal) available for a specified NOAA station.
}
\examples{
\dontrun{
# examples require internet connection
noaa.parameters()
LA.stns <- noaa.stations(state = "LA")
noaa.parameters(LA.stns$number[1])
}
}
\seealso{
\code{\link{noaa}}, \code{\link{noaa.stations}}
}
