% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSdata.R
\name{WACSdata}
\alias{WACSdata}
\title{Format data for WACS}
\usage{
WACSdata(data, mapping = NULL, bounds = NULL, from = NULL, to = NULL,
  skip = NULL, Trange = FALSE, seasons = c("03-01", "06-01", "09-01",
  "12-01"))
}
\arguments{
\item{data}{A dataframe containing series of values for each variable}

\item{mapping}{The names of special variables: year, month, day, rain, 
tmin and tmax. Eg. list(RR = "rain", Tmin = "tmin") [optional; default is NULL]}

\item{bounds}{A list of lists indicating the bounds for some variables
eg. list(rain=list(min=0, max=7)) [optional; default is NULL]
If not provided is set automatically according to data}

\item{from}{Date at which the estimation should begin [optional; default is NULL]}

\item{to}{Date at which the estimation should stop [optional; default is NULL]}

\item{skip}{Vector of column names to skip[optional; default is NULL]}

\item{Trange}{Boolean value. When 
\code{Trange=TRUE}, the couple \code{(tmin, trange=tmax-tmin)} is modeled. When
\code{Trange=FALSE}, he couple \code{(tmin, tmax)} is modeled. Default is \code{Trange=FALSE}}

\item{seasons}{Vector of string of format 'mm-dd', gives the dates
of change of seasons 
(default: is c("03-01", "06-01", "09-01","12-01"))}
}
\value{
A data frame structure, which will be used to call \link{WACSestim}, the function that estimates the parameters of the statistical model.
}
\description{
\code{WACSdata} Builds a data structure compatible with WACS functions
}
\note{
\code{bounds} can be provided as a list, as shown above.  If \code{bounds=NULL}, bounds are computed from the data. Some variables will have minimal values set automatically to 0
(\code{trange,V,RG,ETPP}) and maximal values to 100 (\code{ETPP}). Other minimum (resp. maximum) values are computed by adding (resp. subtracting) to 
the maximum (resp. minimum value) its difference to the 10th largest (resp. lowest) value.


\code{from} and \code{to} must be provided with format 'yyyy-mm-dd' (e.g. '2012-01-30').

There can be as many seasons as desired, with unequal length. There can also be one single season, in which case a single date is entered. 

Default is \code{seasons = c("03-01","06-01","09-01","12-01")}.
}
\examples{
\dontrun{
  ## Simple example
  ThisData = WACSdata(ClimateSeries,from="1995-01-01",to="2012-12-31",
                      Trange=F,seasons=c("03-01","06-01","09-01","12-01"))
 }
 
}
\author{
D. Allard, BioSP, Ronan Trépos MIA-T, INRA
}

