% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise_VT.R
\name{stepwise.VT.val}
\alias{stepwise.VT.val}
\title{Calculate stepwise high order VT in validation}
\usage{
stepwise.VT.val(data, J, dwt, mode = c("MRA", "MODWT", "AT"), detrend = FALSE)
}
\arguments{
\item{data}{A list of data, including response and predictors}

\item{J}{Specifies the depth of the decomposition. This must be a number less than or equal to log(length(x),2).}

\item{dwt}{Output from dwt.vt(), including the transformation covariance}

\item{mode}{A mode of variance transformation, i.e., MRA, MODWT, or AT}

\item{detrend}{Detrend the input time series or just center, default (F)}
}
\value{
A list of objects, including transformed predictors
}
\description{
Calculate stepwise high order VT in validation
}
\examples{
### Real-world example
data("rain.mon")
data("obs.mon")
mode <- switch(1,
  "MRA",
  "MODWT",
  "a trous"
)
wf <- "d4"
station.id <- 5 # station to investigate
SPI.12 <- SPEI::spi(rain.mon, scale = 12)$fitted
lab.names <- colnames(obs.mon)
# plot.ts(SPI.12[,1:10])

#--------------------------------------
### calibration
x <- window(SPI.12[, station.id], start = c(1950, 1), end = c(1979, 12))
dp <- window(obs.mon[, lab.names], start = c(1950, 1), end = c(1979, 12))

data <- list(x = x, dp = matrix(dp, ncol = ncol(dp)))
dwt <- stepwise.VT(data, mode = mode, wf = wf, flag = "biased")
cpy <- dwt$cpy
#--------------------------------------
### validation
x <- window(SPI.12[, station.id], start = c(1980, 1), end = c(2009, 12))
dp <- window(obs.mon[, lab.names], start = c(1980, 1), end = c(2009, 12))

data.n <- list(x = x, dp = matrix(dp, ncol = ncol(dp)))
dwt.val <- stepwise.VT.val(data = data.n, dwt = dwt, mode = mode)

### plot transformed predictor before and after
op <- par(mfrow = c(length(cpy), 1), mar = c(0, 3, 2, 1))
for (i in seq_along(cpy))
{
  ts.plot(cbind(dwt.val$dp[, i], dwt.val$dp.n[, i]), xlab = "NA", col = 1:2)
}
par(op)
}
