% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_n_copies.R
\name{calc_n_copies}
\alias{calc_n_copies}
\title{Calculate number of target copies}
\usage{
calc_n_copies(ct_values, target_names, standard_curves)
}
\arguments{
\item{ct_values}{A numeric vector giving the Ct value for each observation.}

\item{target_names}{A character vector giving the target names for each element in 'ct_values'.}

\item{standard_curves}{A data.frame containing results from standard curve dilution experiment.
Elements in 'target_names' must map to either 'target_name_unique' or 'target_name_concise'. See package
data object \code{template_WES_standard_curves} for template.}
}
\value{
Vector
}
\description{
This function calculates the quantitative value of the qPCR Ct value. Cycle threshold here is converted into
the estimated number of gene target copies (e.g. viral load for a viral pathogen) by fitting a log linear model
to the standard curve data and then using that model to find a point estimate for the provided Ct values.
}
\examples{

df <- template_WES_data[template_WES_data$target_name == 'target_1',]
sc <- template_WES_standard_curve[template_WES_standard_curve$target_name == 'target_1',]

tmp <- calc_n_copies(ct_values = df$ct_value,
                     target_names = df$target_name,
                     standard_curves = sc)

df$n_copies <- tmp
head(df)

}
