% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodfit.R
\name{goodfit}
\alias{goodfit}
\title{Quantile regression goodness of fit}
\usage{
goodfit(resid, resid_nl, tau)
}
\arguments{
\item{resid}{numeric vector of residuals from the conditional quantile model}

\item{resid_nl}{numeric vector of residuals from the non-conditional (null) quantile model}

\item{tau}{numeric value from zero to one for the estimated quantile}
}
\value{
A numeric value from 0 to 1 indicating goodness of fit
}
\description{
Calculate quantile regression goodness of fit using residuals and non-conditional residuals
}
\details{
The goodness of fit measure for quantile regression is estimated as 1 minus the ratio between the sum of absolute deviations in the fully parameterized models and the sum of absolute deviations in the null (non-conditional) quantile model.  The values are useful for comparisons between quantile models, but they are not comparable to standard coefficients of determination. The latter is based on the variance of squared deviations, whereas goodness of fit values for quantile regression are based on absolute deviations.  Goodness of fit values will always be smaller than R2 values.
}
\examples{

library(quantreg)

## random variables
x <- runif(100, 0, 10)
y <- x + rnorm(100)

## quantile model
mod <- rq(y ~ x, tau = 0.5)
res <- resid(mod)

## non-conditional quantile model
mod_nl <- rq(y ~ 1, tau = 0.5)
rsd_nl <- resid(mod_nl)

goodfit(res, rsd_nl, 0.5)

## r2 of mean model for comparison
mod_lm <- lm(y ~ x)

summary(mod_lm)$r.squared
}
\references{
Koenker, R., Machado, J.A.F. 1999. Goodness of fit and related inference processes for quantile regression. Journal of the American Statistical Association. 94(448):1296-1310.
}
\seealso{
\code{\link{wrtdsrsd}} for residuals
}

