% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistDensityNormal}
\alias{PlotDistDensityNormal}
\title{Plot an empirical density with the matching normal distribution}
\usage{
PlotDistDensityNormal(frm, xvar, title)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}
}
\description{
Compares empirical data to a normal distribution with the same mean and standard deviation.
}
\details{
Plots the empirical density, the theoretical matching normal, the mean value,
and plus/minus one standard deviation from the mean.
}
\examples{

set.seed(52523)
d <- data.frame(wt=100*rnorm(100))
PlotDistDensityNormal(d,'wt','example')

}
