% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_weightit-methods.R
\name{glm_weightit-methods}
\alias{glm_weightit-methods}
\alias{summary.glm_weightit}
\alias{print.glm_weightit}
\alias{vcov.glm_weightit}
\alias{confint.glm_weightit}
\title{Methods for \code{glm_weightit()} objects}
\usage{
\method{summary}{glm_weightit}(object, ci = FALSE, level = 0.95, transform = NULL, ...)

\method{print}{glm_weightit}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{vcov}{glm_weightit}(object, complete = TRUE, ...)

\method{confint}{glm_weightit}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object, x}{an output from one of the above modeling functions.}

\item{ci}{\code{logical}; whether to display Wald confidence intervals for estimated coefficients. Default is \code{FALSE}.}

\item{level}{when \code{ci = TRUE}, the desired confidence level.}

\item{transform}{the function used to transform the coefficients, e.g., \code{exp} (which can also be supplied as a string, e.g., \code{"exp"}); passed to \code{\link[=match.fun]{match.fun()}} before being used on the coefficients. When \code{ci = TRUE}, this is also applied to the confidence interval bounds. If specified, the standard error will be omitted from the output. Default is no transformation.}

\item{\dots}{ignored.}

\item{digits}{the number of \emph{significant} digits to be
    passed to \code{\link{format}(\link[stats]{coef}(x), .)} when
    \code{\link{print}()}ing.}

\item{complete}{\code{logical}; whether the full variance-covariance matrix should be returned also in case of an over-determined system where some coefficients are undefined and \code{coef(.)} contains \code{NA}s correspondingly. When \code{complete = TRUE}, \code{vcov()} is compatible with \code{coef()} also in this singular case.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}
}
\value{
\code{summary()} returns a \code{summary.glm_weightit()} object, which has its own print method. For \code{coxph_weightit()} objects, the \code{print()} and \code{summary()} methods are more like those for \code{glm} objects then for \code{coxph} objects.

Otherwise, all methods return the same type of object as their generics.
}
\description{
This page documents methods for objects returned by \code{\link[=glm_weightit]{glm_weightit()}}, \code{lm_weightit()}, \code{ordinal_weightit()}, \code{multinom_weightit()}, and \code{coxph_weightit()}. \code{predict()} methods are described at \code{\link[=predict.glm_weightit]{predict.glm_weightit()}}.
}
\details{
\code{vcov()} (which is called by \code{summary()}) simply extracts the covariance matrix already computed by the fitting function. \code{confint()} computes Wald confidence intervals (internally calling \code{\link[=confint.lm]{confint.lm()}}). The \code{estfun()} method for \code{multinom_weightit} and \code{ordinal_weightit} objects (which is used by function in the \pkg{sandwich} package to compute coefficient covariance matrices) simply extracts the \code{gradient} component of the object. For \code{glm_weightit} and \code{coxph_weightit} objects, the \code{glm} and \code{coxph} methods are dispatched instead.
}
\examples{
## See examples at ?glm_weightit

}
\seealso{
\code{\link[=glm_weightit]{glm_weightit()}} for the page documenting \code{glm_weightit()}, \code{lm_weightit()}, \code{ordinal_weightit()}, \code{multinom_weightit()}, and \code{coxph_weightit()}. \code{\link[=summary.glm]{summary.glm()}}, \link{vcov}, \code{\link[=confint]{confint()}} for the relevant methods pages. \code{\link[=predict.glm_weightit]{predict.glm_weightit()}} for computing predictions from the models.
}
