% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{corpus_contrib_create}
\alias{corpus_contrib_create}
\title{Creating a contributor corpus}
\usage{
corpus_contrib_create(method, x, limit = "max", domain = "fr")
}
\arguments{
\item{method}{The method employed to get data into the corpus. \describe{
\item{category}{Every contributor page included in the category x would be
included in the corpus} \item{random}{Select x random contributor page}
\item{xpath}{x is a vector containing in first position the URL of one
page, and in second position the wpath request to apply to this URL. Will
return a list of words, wich are the names of the contributors if the xpath
request is writed correctly} }}

\item{x}{The pointer of the method.}

\item{limit}{If not 'max', then an integer giving the corpus size. Useless
for random method.}

\item{domain}{The domain where the wiki is located.}
}
\value{
A character vector
}
\description{
Creating a contributor corpus
}
\examples{
# Creating a contributor corpus formed by contributors of the 'Action' page on the french wiki.
corpus_contrib_create('page','Action')

# Same as previous, by limiting the size of the corpus at 5 contributors.
corpus_contrib_create('page','Action',limit=5)
}
\seealso{
\code{\link{corpus_contrib_data}} to put data into the corpus you
  made with this function, \code{\link{corpus_contrib_select}} to clean the
  corpus with a specific criteria

Other corpus functions: \code{\link{corpus_contrib_data}},
  \code{\link{corpus_contrib_select}},
  \code{\link{corpus_page_create}},
  \code{\link{corpus_page_data}}
}

