% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countrycoord_data.R
\name{countrycoord_data}
\alias{countrycoord_data}
\title{countrycoord_data}
\usage{
countrycoord_data(
  countries.list = NULL,
  crs = 4326,
  UK_as_GB = TRUE,
  exclude.iso.na = TRUE
)
}
\arguments{
\item{countries.list}{List of the ISO 3166-1 alpha-2 codes of countries that are to be included. By default it is set to \code{NULL} and all countries are included.}

\item{crs}{Coordinate reference system (EPSG). By default the value is 4326, which corresponds to EPSG::4326 (WGS84)}

\item{UK_as_GB}{Do you want to translate the GB isoa2 code to UK? If FALSE, GB is returned in the output data.frame. 
If TRUE, UK is returned.
Note that you will need to provide GB as the input for United Kingdom, even if you want the UK label to be
returned in output.}

\item{exclude.iso.na}{if \code{TRUE} (default), countries that do not have a ISO 3166 code are excluded from the table.}
}
\value{
an object of class \code{data.frame}
}
\description{
This function generates a data frame with information about the coordinates of the central point for each
country of interest. You can choose whether to keep all the countries or only a subset.
}
\examples{
countrycoord_data(countries.list = c("IT", "FR", "SE"), crs = 3035)
countrycoord_data(countries.list = c("IT", "FR", "SE"), crs = 3035)
countrycoord_data(countries.list = c("IT", "FR", "SE", "GB"), crs = 3035, UK_as_GB = TRUE)
countrycoord_data(countries.list = c("IT", "FR", "SE", "GB"), crs = 3035, UK_as_GB = FALSE)

}
