% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{stepwise_method_options}
\alias{stepwise_method_options}
\title{Options For Use With the Stepwise Selection Method}
\usage{
stepwise_method_options(
  force = NULL,
  direction = c("backward", "forward"),
  method = c("binary program", "projection"),
  transport.method = transport_options(),
  OTmaxit = 100,
  epsilon = 0.05,
  model.size = NULL,
  display.progress = FALSE,
  parallel = NULL,
  calc.theta = TRUE,
  ...
)
}
\arguments{
\item{force}{Any covariates to force into the model? Should be by column number or NULL if no variables to force into the model.}

\item{direction}{"forward" or "backward" selection? Default is "backward"}

\item{method}{Should covariates be selected as an approximate "binary program" or should a projection method be used. Default is the approximate binary program.}

\item{transport.method}{Method for Wasserstein distance calculation. Should be one the outputs of \code{\link[=transport_options]{transport_options()}}}

\item{OTmaxit}{The number of iterations to run the Wasserstein distance solvers.}

\item{epsilon}{A value > 0 for the penalty parameter of if using the Sinkhorn method for optimal transport}

\item{model.size}{How many coefficients should the maximum final model have?}

\item{display.progress}{Logical. Should intermediate progress be displayed? TRUE or FALSE. Default is FALSE.}

\item{parallel}{A cluster backend to be used by \code{\link[foreach:foreach]{foreach::foreach()}}. See \code{\link[foreach:foreach]{foreach::foreach()}} for details about how to set them up. The \code{WpProj} functions will register the cluster with the \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}} function internally.}

\item{calc.theta}{Return the linear coefficients? Default is TRUE.}

\item{...}{Not used}
}
\value{
A named list with the above arguments
}
\description{
Options For Use With the Stepwise Selection Method
}
\examples{
stepwise_method_options()
}
