% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/W1L1.R
\name{W1L1}
\alias{W1L1}
\title{1-Wasserstein projection}
\usage{
W1L1(
  X,
  Y,
  theta = NULL,
  penalty = c("none", "lasso", "scad", "mcp"),
  model.size = NULL,
  lambda = numeric(0),
  lambda.min.ratio = 1e-04,
  nlambda = 10,
  gamma = 1,
  display.progress = FALSE,
  solver = c("cone", "rqPen", "gurobi", "mosek"),
  ...
)
}
\arguments{
\item{X}{Covariates}

\item{Y}{Predictions from arbitrary model}

\item{theta}{Parameters of original linear model. Optional.}

\item{penalty}{penalty term to use. One of "none", "lasso","scad","mcp"}

\item{model.size}{Maximum number of coefficients in interpretable model}

\item{lambda}{Lambdas to use}

\item{lambda.min.ratio}{Minimum lambda to select if choosing lambdas using default methods}

\item{nlambda}{number of lambdas to look through}

\item{gamma}{parameter for SCAD and MCP methods}

\item{display.progress}{Print intermediate output?}

\item{solver}{Solver to use. Must be one of "rqPen", "gurobi", "mosek", though "mosek" is preferred.}

\item{...}{options to pass to solvers}
}
\value{
\code{WpProj} object
}
\description{
1-Wasserstein projection
}
\keyword{internal}
