% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xDAGpropagate.r
\name{xDAGpropagate}
\alias{xDAGpropagate}
\title{Function to generate a subgraph of a direct acyclic graph (DAG) propagaged by the input annotation data}
\usage{
xDAGpropagate(g, annotation, path.mode = c("all_paths",
"shortest_paths",
"all_shortest_paths"), propagation = c("min", "max"), verbose = TRUE)
}
\arguments{
\item{g}{an object of class "igraph" to represent DAG}

\item{annotation}{the vertices/nodes for which annotation data are
provided. It can be a sparse Matrix of class "dgCMatrix" (with
variants/genes as rows and terms as columns), or a data frame with
three columns: 1st column for variants/genes, 2nd column for terms, and
3rd column for values}

\item{path.mode}{the mode of paths induced by vertices/nodes with input
annotation data. It can be "all_paths" for all possible paths to the
root, "shortest_paths" for only one path to the root (for each node in
query), "all_shortest_paths" for all shortest paths to the root (i.e.
for each node, find all shortest paths with the equal lengths)}

\item{propagation}{how to propagate the score. It can be "max" for
retaining the maximum value from its children, "min" for retaining the
minimum value from its children}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
\itemize{
\item{\code{subg}: an induced subgraph, an object of class "igraph". In
addition to the original attributes to nodes and edges, the return
subgraph is also appended by two node attributes: 1) "anno" containing
a list of variants/genes (with numeric values as elements); 2) "IC"
standing for information content defined as negative 10-based
log-transformed frequency of variants/genes annotated to that term.}
}
}
\description{
\code{xDAGpropagate} is supposed to produce a subgraph induced by the
input annotation data, given a direct acyclic graph (DAG; an ontology).
The input is a graph of "igraph", a list of the vertices containing
annotation data, and the mode defining the paths to the root of DAG.
The annotations are propagated to the ontology root (eg, retaining the
minmum pvalue). The propagaged subgraph contains vertices (with
annotation data) and their ancestors along with the defined paths to
the root of DAG. The annotations at these vertices (including their
ancestors) can also be updated according to the true-path rule: those
annotated to a term should also be annotated by its all ancestor terms.
}
\note{
For the mode "shortest_paths", the induced subgraph is the most
concise, and thus informative for visualisation when there are many
nodes in query, while the mode "all_paths" results in the complete
subgraph.
}
\examples{
\dontrun{
# 1) SNP-based ontology
# 1a) ig.EF (an object of class "igraph" storing as a directed graph)
g <- xRDataLoader('ig.EF')

# 1b) load GWAS SNPs annotated by EF (an object of class "dgCMatrix" storing a spare matrix)
anno <- xRDataLoader(RData='GWAS2EF')

# 1c) prepare for annotation data
# randomly select 5 terms/vertices (and their annotation data)
annotation <- anno[, sample(1:dim(anno)[2],5)]

# 1d) obtain the induced subgraph according to the input annotation data
# based on shortest paths (i.e. the most concise subgraph induced)
dag <- xDAGpropagate(g, annotation, path.mode="shortest_paths",
propagation="min", verbose=TRUE)

# 1e) color-code nodes/terms according to the number of annotations
data <- sapply(V(dag)$anno, length)
names(data) <- V(dag)$name
dnet::visDAG(g=dag, data=data, node.info="both")
}
}
\seealso{
\code{\link{xRDataLoader}}
}
