% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xDefineNet.r
\name{xDefineNet}
\alias{xDefineNet}
\title{Function to define a gene network}
\usage{
xDefineNet(network = c("STRING_highest", "STRING_high",
"STRING_medium",
"STRING_low", "PCommonsUN_high", "PCommonsUN_medium",
"PCommonsDN_high",
"PCommonsDN_medium", "PCommonsDN_Reactome", "PCommonsDN_KEGG",
"PCommonsDN_HumanCyc", "PCommonsDN_PID", "PCommonsDN_PANTHER",
"PCommonsDN_ReconX", "PCommonsDN_TRANSFAC", "PCommonsDN_PhosphoSite",
"PCommonsDN_CTD", "KEGG", "KEGG_metabolism", "KEGG_genetic",
"KEGG_environmental", "KEGG_cellular", "KEGG_organismal",
"KEGG_disease",
"REACTOME"), STRING.only = c(NA, "neighborhood_score", "fusion_score",
"cooccurence_score", "coexpression_score", "experimental_score",
"database_score", "textmining_score")[1], weighted = FALSE,
verbose = TRUE, RData.location =
"http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{network}{the built-in network. Currently two sources of network
information are supported: the STRING database (version 10) and the
Pathway Commons database (version 7). STRING is a meta-integration of
undirect interactions from the functional aspect, while Pathways
Commons mainly contains both undirect and direct interactions from the
physical/pathway aspect. Both have scores to control the confidence of
interactions. Therefore, the user can choose the different quality of
the interactions. In STRING, "STRING_highest" indicates interactions
with highest confidence (confidence scores>=900), "STRING_high" for
interactions with high confidence (confidence scores>=700),
"STRING_medium" for interactions with medium confidence (confidence
scores>=400), and "STRING_low" for interactions with low confidence
(confidence scores>=150). For undirect/physical interactions from
Pathways Commons, "PCommonsUN_high" indicates undirect interactions
with high confidence (supported with the PubMed references plus at
least 2 different sources), "PCommonsUN_medium" for undirect
interactions with medium confidence (supported with the PubMed
references). For direct (pathway-merged) interactions from Pathways
Commons, "PCommonsDN_high" indicates direct interactions with high
confidence (supported with the PubMed references plus at least 2
different sources), and "PCommonsUN_medium" for direct interactions
with medium confidence (supported with the PubMed references). In
addition to pooled version of pathways from all data sources, the user
can also choose the pathway-merged network from individual sources,
that is, "PCommonsDN_Reactome" for those from Reactome,
"PCommonsDN_KEGG" for those from KEGG, "PCommonsDN_HumanCyc" for those
from HumanCyc, "PCommonsDN_PID" for those froom PID,
"PCommonsDN_PANTHER" for those from PANTHER, "PCommonsDN_ReconX" for
those from ReconX, "PCommonsDN_TRANSFAC" for those from TRANSFAC,
"PCommonsDN_PhosphoSite" for those from PhosphoSite, and
"PCommonsDN_CTD" for those from CTD. For direct (pathway-merged)
interactions sourced from KEGG, it can be 'KEGG' for all,
'KEGG_metabolism' for pathways grouped into 'Metabolism',
'KEGG_genetic' for 'Genetic Information Processing' pathways,
'KEGG_environmental' for 'Environmental Information Processing'
pathways, 'KEGG_cellular' for 'Cellular Processes' pathways,
'KEGG_organismal' for 'Organismal Systems' pathways, and 'KEGG_disease'
for 'Human Diseases' pathways. 'REACTOME' for protein-protein
interactions derived from Reactome pathways}

\item{STRING.only}{the further restriction of STRING by interaction
type. If NA, no such restriction. Otherwide, it can be one or more of
"neighborhood_score","fusion_score","cooccurence_score","coexpression_score","experimental_score","database_score","textmining_score".
Useful options are c("experimental_score","database_score"): only
experimental data (extracted from BIND, DIP, GRID, HPRD, IntAct, MINT,
and PID) and curated data (extracted from Biocarta, BioCyc, GO, KEGG,
and Reactome) are used}

\item{weighted}{logical to indicate whether edge weights should be
considered. By default, it sets to false. If true, it only works for
the network from the STRING database}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
an object of class "igraph"
}
\description{
\code{xDefineNet} is supposed to define a gene network sourced from the
STRING database or the Pathway Commons database. It returns an object
of class "igraph".
}
\note{
The input graph will treat as an unweighted graph if there is no
'weight' edge attribute associated with
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"
\dontrun{
# STRING (high quality)
g <- xDefineNet(network="STRING_high", RData.location=RData.location)
# STRING (high quality), with edges weighted 
g <- xDefineNet(network="STRING_high", weighted=T,
RData.location=RData.location)
# STRING (high quality), only edges sourced from experimental or curated data
g <- xDefineNet(network="STRING_high",
STRING.only=c("experimental_score","database_score"),
RData.location=RData.location)

# Pathway Commons 
g <- xDefineNet(network="PCommonsDN_medium",
RData.location=RData.location)

# KEGG (all)
g <- xDefineNet(network="KEGG", RData.location=RData.location)
# KEGG ('Organismal Systems')
g <- xDefineNet(network="KEGG_organismal",
RData.location=RData.location)
}
}
\seealso{
\code{\link{xCombineNet}}
}
