% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichHeatmap.r
\name{xEnrichHeatmap}
\alias{xEnrichHeatmap}
\title{Function to visualise enrichment results using heatmap}
\usage{
xEnrichHeatmap(list_eTerm, fdr.cutoff = 0.05, displayBy = c("zscore",
"fdr",
"pvalue", "fc", "or"), colormap = NULL, zlim = NULL, reorder =
c("none",
"row", "col", "both"))
}
\arguments{
\item{list_eTerm}{an object of class "ls_eTerm". Alterntively, it can
be a data frame having all these columns (named as
'group','ontology','name','adjp') and one of these columns
("zscore","fdr","pvalue","fc","or"). Note, the column 'fdr' can be
inferred from the column 'adjp'}

\item{fdr.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{displayBy}{which statistics will be used for comparison. It can
be "fc" for enrichment fold change (by default), "adjp" for adjusted p
value (or FDR), "pvalue" for p value, "zscore" for enrichment z-score,
"or" for enrichment odd ratio}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted, defaulting to the range of the -log10(FDR)}

\item{reorder}{how to reorder rows and columns. It can be "none" for no
reordering, "row" for reordering rows according to number of sharings
(by default), "col" for reordering columns, and "both" for reordering
rows and columns}
}
\value{
an object of class "ggplot"
}
\description{
\code{xEnrichHeatmap} is supposed to visualise enrichment results using
heatmap. It returns an object of class "ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"

# provide the input Genes of interest (eg 100 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg',
RData.location=RData.location)
set.seed(825)
data <- as.character(sample(org.Hs.eg$gene_info$Symbol, 100))
data

# optionally, provide the test background (if not provided, all human genes)
#background <- as.character(org.Hs.eg$gene_info$Symbol)

# 2) Gene-based enrichment analysis using ontologies (REACTOME and GOMF)
# perform enrichment analysis
ls_eTerm <- xEnricherGenesAdv(data, ontologies=c("REACTOME","GOMF"),
RData.location=RData.location)
## heatmap plot of enrichment results
gp <- xEnrichHeatmap(ls_eTerm, fdr.cutoff=0.1, displayBy="zscore")
}
}
\seealso{
\code{\link{xHeatmap}}
}
