/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.DataFormatOnlyCellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.HCellStyle;
import com.miraisolutions.xlconnect.SSCellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.XCellStyle;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workbook
extends Common {
    private final org.apache.poi.ss.usermodel.Workbook workbook;
    private File excelFile;
    private StyleAction styleAction = StyleAction.XLCONNECT;
    private String styleNamePrefix = null;
    private String[] missingValue = new String[]{null};
    private final Map<String, Map<String, CellStyle>> stylesMap = new HashMap<String, Map<String, CellStyle>>(10);
    private final Map<DataType, String> dataFormatMap = new EnumMap<DataType, String>(DataType.class);
    private ErrorBehavior onErrorCell = ErrorBehavior.WARN;

    private Workbook(InputStream inputStream) throws IOException, InvalidFormatException {
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
        this.excelFile = null;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private Workbook(File excelFile) throws FileNotFoundException, IOException, InvalidFormatException {
        this(new FileInputStream(excelFile));
        this.excelFile = excelFile;
    }

    private Workbook(File file, SpreadsheetVersion spreadsheetVersion) {
        switch (spreadsheetVersion) {
            case EXCEL97: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case EXCEL2007: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException("Spreadsheet version not supported!");
            }
        }
        this.excelFile = file;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private void initDefaultStyles() {
        CellStyle cellStyle;
        CellStyle cellStyle2;
        HashMap<String, CellStyle> hashMap = new HashMap<String, CellStyle>(5);
        CellStyle cellStyle3 = this.getCellStyle("XLConnect.Header");
        if (cellStyle3 == null) {
            cellStyle3 = this.createCellStyle("XLConnect.Header");
            cellStyle3.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle3.setFillPattern((short)1);
            cellStyle3.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle3.setWrapText(true);
        }
        if ((cellStyle2 = this.getCellStyle("XLConnect.General")) == null) {
            cellStyle2 = this.createCellStyle("XLConnect.General");
            cellStyle2.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
            cellStyle2.setWrapText(true);
        }
        if ((cellStyle = this.getCellStyle("XLConnect.Date")) == null) {
            cellStyle = this.createCellStyle("XLConnect.Date");
            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
            cellStyle.setWrapText(true);
        }
        hashMap.put("Header", cellStyle3);
        hashMap.put("String", cellStyle2);
        hashMap.put("Numeric", cellStyle2);
        hashMap.put("Boolean", cellStyle2);
        hashMap.put("DateTime", cellStyle);
        this.stylesMap.put("XLCONNECT_STYLE", hashMap);
    }

    private void initDefaultDataFormats() {
        this.dataFormatMap.put(DataType.Boolean, "General");
        this.dataFormatMap.put(DataType.DateTime, "mm/dd/yyyy hh:mm:ss");
        this.dataFormatMap.put(DataType.Numeric, "General");
        this.dataFormatMap.put(DataType.String, "General");
    }

    public final void setDataFormat(DataType dataType, String string) {
        this.dataFormatMap.put(dataType, string);
    }

    public final void setStyleAction(StyleAction styleAction) {
        this.styleAction = styleAction;
    }

    public final void setStyleNamePrefix(String styleNamePrefix) {
        this.styleNamePrefix = styleNamePrefix;
    }

    public final String[] getSheets() {
        int count = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[count];
        for (int i = 0; i < count; ++i) {
            sheetNames[i] = this.workbook.getSheetName(i);
        }
        return sheetNames;
    }

    public final int getSheetPos(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    public final void setSheetPos(String sheetName, int pos) {
        this.workbook.setSheetOrder(sheetName, pos);
    }

    public final String[] getDefinedNames(boolean bl) {
        int n = this.workbook.getNumberOfNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Name name = this.workbook.getNameAt(i);
            if (bl && !Workbook.isValidReference(name.getRefersToFormula())) continue;
            arrayList.add(name.getNameName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final boolean existsSheet(String string) {
        return this.workbook.getSheet(string) != null;
    }

    public final boolean existsName(String string) {
        return this.workbook.getName(string) != null;
    }

    public final void createSheet(String string) {
        if (string.length() > 31) {
            throw new IllegalArgumentException("Sheet names are not allowed to contain more than 31 characters!");
        }
        if (this.workbook.getSheetIndex(string) < 0) {
            this.workbook.createSheet(string);
        }
    }

    public final void removeSheet(int n) {
        if (n >= 0 && n < this.workbook.getNumberOfSheets()) {
            this.setAlternativeActiveSheet(n);
            this.workbook.removeSheetAt(n);
        }
    }

    public final void removeSheet(String name) {
        this.removeSheet(this.workbook.getSheetIndex(name));
    }

    public final void renameSheet(int sheetIndex, String newName) {
        this.renameSheet(this.workbook.getSheetName(sheetIndex), newName);
    }

    public final void renameSheet(String name, String newName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex(name), newName);
    }

    public final void cloneSheet(int index, String newName) {
        this.cloneSheet(this.workbook.getSheetName(index), newName);
    }

    public final void cloneSheet(String name, String newName) {
        Sheet sheet = this.workbook.cloneSheet(this.workbook.getSheetIndex(name));
        this.workbook.setSheetName(this.workbook.getSheetIndex(sheet), newName);
    }

    public final void createName(String string, String string2, boolean bl) {
        if (this.existsName(string)) {
            if (bl) {
                this.removeName(string);
            } else {
                throw new IllegalArgumentException("Specified name '" + string + "' already exists!");
            }
        }
        Name name = this.workbook.createName();
        try {
            name.setNameName(string);
            name.setRefersToFormula(string2);
            return;
        }
        catch (Exception exception) {
            string2 = "XLConnectDummyName";
            name.setNameName(string2);
            this.removeName(string2);
            throw new IllegalArgumentException(exception);
        }
    }

    public final void removeName(String string) {
        if (this.workbook.getName(string) != null) {
            this.workbook.removeName(string);
        }
    }

    public final String getReferenceFormula(String name) {
        return this.getName(name).getRefersToFormula();
    }

    public final int[] getReferenceCoordinates(String string) {
        string = this.getName(string);
        string = new AreaReference(string.getRefersToFormula());
        CellReference cellReference = string.getFirstCell();
        string = string.getLastCell();
        int n = cellReference.getRow();
        int n2 = string.getRow();
        short s = cellReference.getCol();
        short s2 = string.getCol();
        return new int[]{n, s, n2, s2};
    }

    private void writeData(DataFrame dataFrame, Sheet sheet, int n, int n2, boolean n3) {
        int n4;
        int n5;
        Object object = sheet;
        DataFrame dataFrame2 = dataFrame;
        Map<String, CellStyle> map = this;
        Serializable serializable = new HashMap<String, CellStyle>(dataFrame2.columns());
        switch (((Workbook)((Object)map)).styleAction) {
            case XLCONNECT: {
                map = ((Workbook)((Object)map)).stylesMap.get("XLCONNECT_STYLE");
                if (dataFrame2.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                        serializable.put("Header" + n5, map.get("Header"));
                    }
                }
                block20: for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                    switch (dataFrame2.getColumnType(n5)) {
                        case Boolean: {
                            serializable.put("Column" + n5, map.get("Boolean"));
                            continue block20;
                        }
                        case DateTime: {
                            serializable.put("Column" + n5, map.get("DateTime"));
                            continue block20;
                        }
                        case Numeric: {
                            serializable.put("Column" + n5, map.get("Numeric"));
                            continue block20;
                        }
                        case String: {
                            serializable.put("Column" + n5, map.get("String"));
                            continue block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type detected!");
                        }
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            case PREDEFINED: {
                if (dataFrame2.hasColumnHeader()) {
                    for (n5 = 0; n5 < dataFrame2.columns(); ++n5) {
                        n4 = n2 + n5;
                        serializable.put("Header" + n5, super.getCellStyle(Workbook.getCell(object, n, n4, true)));
                    }
                }
                n5 = n + (dataFrame2.hasColumnHeader() ? 1 : 0);
                for (int i = 0; i < dataFrame2.columns(); ++i) {
                    n4 = n2 + i;
                    int n6 = n5;
                    Cell cell = Workbook.getCell(object, n6, n4, true);
                    serializable.put("Column" + i, super.getCellStyle(cell));
                }
                break;
            }
            case STYLE_NAME_PREFIX: {
                String string;
                int n7;
                if (dataFrame2.hasColumnHeader()) {
                    for (n7 = 0; n7 < dataFrame2.columns(); ++n7) {
                        string = ((Workbook)((Object)map)).styleNamePrefix + "." + "Header";
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnName(n7));
                        if (object == null) {
                            object = ((Workbook)((Object)map)).getCellStyle(string + "." + (n7 + 1));
                        }
                        if (object == null) {
                            object = ((Workbook)((Object)map)).getCellStyle(string);
                        }
                        if (object == null) {
                            object = new SSCellStyle(((Workbook)((Object)map)).workbook, ((Workbook)((Object)map)).workbook.getCellStyleAt((short)0));
                        }
                        serializable.put("Header" + n7, object);
                    }
                }
                for (n7 = 0; n7 < dataFrame2.columns(); ++n7) {
                    string = ((Workbook)((Object)map)).styleNamePrefix + "." + "Column";
                    object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnName(n7));
                    if (object == null) {
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + (n7 + 1));
                    }
                    if (object == null) {
                        object = ((Workbook)((Object)map)).getCellStyle(string + "." + dataFrame2.getColumnType(n7).toString());
                    }
                    if (object == null) {
                        object = new SSCellStyle(((Workbook)((Object)map)).workbook, ((Workbook)((Object)map)).workbook.getCellStyleAt((short)0));
                    }
                    serializable.put("Column" + n7, object);
                }
                break;
            }
            case DATA_FORMAT_ONLY: {
                int n8;
                DataFormatOnlyCellStyle dataFormatOnlyCellStyle = DataFormatOnlyCellStyle.get();
                if (dataFrame2.hasColumnHeader()) {
                    for (n8 = 0; n8 < dataFrame2.columns(); ++n8) {
                        serializable.put("Header" + n8, dataFormatOnlyCellStyle);
                    }
                }
                for (n8 = 0; n8 < dataFrame2.columns(); ++n8) {
                    serializable.put("Column" + n8, dataFormatOnlyCellStyle);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Style action not supported!");
            }
        }
        map = serializable;
        int n9 = n;
        int n10 = n2;
        if (n3 != 0 && dataFrame.hasColumnHeader()) {
            for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
                n4 = n2 + n3;
                Cell cell = Workbook.getCell(sheet, n, n4, true);
                cell.setCellType(1);
                cell.setCellValue(dataFrame.getColumnName(n3));
                this.setCellStyle(cell, map.get("Header" + n3));
            }
            ++n9;
        }
        for (n3 = 0; n3 < dataFrame.columns(); ++n3) {
            CellStyle cellStyle = map.get("Column" + n3);
            switch (dataFrame.getColumnType(n3)) {
                case Numeric: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (n2 = 0; n2 < dataFrame.rows(); ++n2) {
                        n4 = n10;
                        n11 = n9 + n2;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        serializable = (Double)arrayList.get(n2);
                        if (serializable == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellType(0);
                        cell.setCellValue(((Double)serializable).doubleValue());
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case String: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (n5 = 0; n5 < dataFrame.rows(); ++n5) {
                        n4 = n10;
                        n11 = n9 + n5;
                        serializable = Workbook.getCell(sheet, n11, n4, true);
                        if ((String)arrayList.get(n5) == null) {
                            this.setMissing((Cell)serializable);
                            continue;
                        }
                        serializable.setCellType(1);
                        serializable.setCellValue((String)arrayList.get(n5));
                        this.setCellStyle((Cell)serializable, cellStyle);
                    }
                    break;
                }
                case Boolean: {
                    int n11;
                    ArrayList arrayList = dataFrame.getColumn(n3);
                    for (int i = 0; i < dataFrame.rows(); ++i) {
                        n4 = n10;
                        n11 = n9 + i;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        if ((Boolean)arrayList.get(i) == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellType(4);
                        cell.setCellValue(((Boolean)arrayList.get(i)).booleanValue());
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                case DateTime: {
                    int n11;
                    serializable = dataFrame.getColumn(n3);
                    for (n = 0; n < dataFrame.rows(); ++n) {
                        n4 = n10;
                        n11 = n9 + n;
                        Cell cell = Workbook.getCell(sheet, n11, n4, true);
                        Date date = (Date)((ArrayList)serializable).get(n);
                        if (date == null) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellType(0);
                        cell.setCellValue(date);
                        this.setCellStyle(cell, cellStyle);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
            ++n10;
        }
        if (this.workbook instanceof HSSFWorkbook) {
            ((HSSFSheet)sheet).setForceFormulaRecalculation(true);
        }
    }

    private DataFrame readData(Sheet sheet, int n, int n2, int n3, int n4, boolean bl) {
        DataFrame dataFrame = new DataFrame();
        FormulaEvaluator formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.clearAllCachedResultValues();
        block25: for (int i = 0; i < n4; ++i) {
            Object object;
            int n5;
            Object object2;
            Object object3;
            int n6 = n2 + i;
            String string = null;
            if (bl && (object3 = Workbook.getCell(sheet, n, n6, false)) != null && (object2 = formulaEvaluator.evaluate((Cell)object3)) != null) {
                string = object2.getStringValue();
            }
            if (string == null) {
                string = "Col" + i;
            }
            object3 = new ColumnBuilder(this, n3);
            int n7 = n5 = bl ? 1 : 0;
            while (n5 < n3) {
                block47: {
                    Object object4;
                    int n8 = n + n5;
                    Cell cell = Workbook.getCell(sheet, n8, n6, false);
                    if (cell == null) {
                        ((ColumnBuilder)object3).addMissing();
                    } else if (cell.getCellType() == 5 || cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 5) {
                        object4 = "Error detected in cell " + CellUtils.formatAsString(cell) + " - " + CellUtils.getErrorMessage(cell.getErrorCellValue());
                        ColumnBuilder.access$000((ColumnBuilder)object3, (String)object4);
                    } else {
                        try {
                            object = formulaEvaluator.evaluate(cell);
                        }
                        catch (Exception exception) {
                            object4 = "Error when trying to evaluate cell " + CellUtils.formatAsString(cell) + " - " + exception.getMessage();
                            ColumnBuilder.access$000((ColumnBuilder)object3, (String)object4);
                            break block47;
                        }
                        if (object == null) {
                            ((ColumnBuilder)object3).addMissing();
                        } else {
                            switch (object.getCellType()) {
                                case 3: {
                                    ((ColumnBuilder)object3).addMissing();
                                    break;
                                }
                                case 4: {
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.Boolean);
                                    break;
                                }
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.DateTime);
                                        break;
                                    }
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.Numeric);
                                    break;
                                }
                                case 1: {
                                    n8 = 0;
                                    for (int j = 0; j < this.missingValue.length; ++j) {
                                        if (object.getStringValue() != null && !object.getStringValue().equals(this.missingValue[j])) continue;
                                        n8 = 1;
                                        break;
                                    }
                                    if (n8 != 0) {
                                        ((ColumnBuilder)object3).addMissing();
                                        break;
                                    }
                                    ColumnBuilder.access$100((ColumnBuilder)object3, object, DataType.String);
                                    break;
                                }
                                case 2: {
                                    object4 = "Formula detected in already evaluated cell " + CellUtils.formatAsString(cell) + "!";
                                    ColumnBuilder.access$000((ColumnBuilder)object3, (String)object4);
                                    break;
                                }
                                case 5: {
                                    object4 = "Error detected in cell " + CellUtils.formatAsString(cell) + " - " + CellUtils.getErrorMessage(object.getErrorValue());
                                    ColumnBuilder.access$000((ColumnBuilder)object3, (String)object4);
                                    break;
                                }
                                default: {
                                    object4 = "Unexpected cell type detected for cell " + CellUtils.formatAsString(cell) + "!";
                                    ColumnBuilder.access$000((ColumnBuilder)object3, (String)object4);
                                }
                            }
                        }
                    }
                }
                ++n5;
            }
            object2 = Workbook.determineColumnType(((ColumnBuilder)object3).detectedTypes);
            switch (1.$SwitchMap$com$miraisolutions$xlconnect$data$DataType[((Enum)object2).ordinal()]) {
                case 3: {
                    ArrayList<Comparable<Boolean>> arrayList = new ArrayList<Comparable<Boolean>>(((ColumnBuilder)object3).values.size());
                    for (Object object4 : ((ColumnBuilder)object3).values) {
                        if (object4 == null) {
                            arrayList.add(null);
                            continue;
                        }
                        arrayList.add(Boolean.valueOf(object4.getBooleanValue()));
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), arrayList);
                    continue block25;
                }
                case 4: {
                    ArrayList<Comparable<Boolean>> arrayList = new ArrayList(((ColumnBuilder)object3).values.size());
                    for (Object object4 : ((ColumnBuilder)object3).values) {
                        if (object4 == null) {
                            arrayList.add(null);
                            continue;
                        }
                        arrayList.add(DateUtil.getJavaDate((double)object4.getNumberValue()));
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), arrayList);
                    continue block25;
                }
                case 1: {
                    ArrayList<Comparable<Boolean>> arrayList = new ArrayList(((ColumnBuilder)object3).values.size());
                    for (Object object4 : ((ColumnBuilder)object3).values) {
                        if (object4 == null) {
                            arrayList.add(null);
                            continue;
                        }
                        object = null;
                        switch (object4.getCellType()) {
                            case 3: {
                                break;
                            }
                            case 4: {
                                object = object4.getBooleanValue() ? 1.0 : 0.0;
                                break;
                            }
                            default: {
                                object = object4.getNumberValue();
                            }
                        }
                        arrayList.add((Comparable<Boolean>)object);
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), arrayList);
                    continue block25;
                }
                case 2: {
                    ArrayList<Comparable<Boolean>> arrayList = new ArrayList(((ColumnBuilder)object3).values.size());
                    for (Object object4 : ((ColumnBuilder)object3).values) {
                        if (object4 == null) {
                            arrayList.add(null);
                            continue;
                        }
                        object = null;
                        switch (object4.getCellType()) {
                            case 3: {
                                break;
                            }
                            case 4: {
                                object = String.valueOf(object4.getBooleanValue());
                                break;
                            }
                            case 0: {
                                if (((ColumnBuilder)object3).isDate.contains(object4)) {
                                    object = DateUtil.getJavaDate((double)object4.getNumberValue()).toString();
                                    break;
                                }
                                object = String.valueOf(object4.getNumberValue());
                                break;
                            }
                            default: {
                                object = object4.getStringValue();
                            }
                        }
                        arrayList.add((Comparable<Boolean>)object);
                    }
                    dataFrame.addColumn(string, (DataType)((Object)object2), arrayList);
                    continue block25;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
        }
        return dataFrame;
    }

    public final void onErrorCell(ErrorBehavior eb) {
        this.onErrorCell = eb;
    }

    public final void writeNamedRegion(DataFrame dataFrame, String string, boolean bl) {
        string = this.getName(string);
        this.checkName((Name)string);
        Sheet sheet = this.workbook.getSheet(string.getSheetName());
        CellReference cellReference = new AreaReference(string.getRefersToFormula()).getFirstCell();
        int n = cellReference.getRow() + dataFrame.rows() - 1;
        if (bl) {
            ++n;
        }
        int n2 = cellReference.getCol() + dataFrame.columns() - 1;
        CellReference cellReference2 = new CellReference(sheet.getSheetName(), n, n2, true, true);
        cellReference2 = new AreaReference(cellReference, cellReference2);
        string.setRefersToFormula(cellReference2.formatAsString());
        this.writeData(dataFrame, sheet, cellReference.getRow(), cellReference.getCol(), bl);
    }

    public final DataFrame readNamedRegion(String string, boolean bl) {
        string = this.getName(string);
        this.checkName((Name)string);
        Sheet sheet = this.workbook.getSheet(string.getSheetName());
        string = new AreaReference(string.getRefersToFormula());
        CellReference cellReference = string.getFirstCell();
        string = string.getLastCell();
        int n = string.getRow() - cellReference.getRow() + 1;
        int n2 = string.getCol() - cellReference.getCol() + 1;
        return this.readData(sheet, cellReference.getRow(), cellReference.getCol(), n, n2, bl);
    }

    public final void writeWorksheet(DataFrame dataFrame, int n, int n2, int n3, boolean bl) {
        Sheet sheet = this.workbook.getSheetAt(n);
        this.writeData(dataFrame, sheet, n2, n3, bl);
    }

    public final void writeWorksheet(DataFrame data, String worksheetName, int startRow, int startCol, boolean header) {
        this.writeWorksheet(data, this.workbook.getSheetIndex(worksheetName), startRow, startCol, header);
    }

    public final void writeWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        this.writeWorksheet(data, worksheetIndex, 0, 0, header);
    }

    public final void writeWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.writeWorksheet(data, worksheetName, 0, 0, header);
    }

    public final DataFrame readWorksheet(int n, int n2, int n3, int n4, int n5, boolean bl) {
        Row row;
        int n6;
        Sheet sheet = this.workbook.getSheetAt(n);
        if (n2 < 0) {
            n2 = sheet.getFirstRowNum();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Start row cannot be determined!");
        }
        if (sheet.getRow(n2) == null) {
            throw new IllegalArgumentException("Specified sheet does not contain any data!");
        }
        if (n4 < 0) {
            n4 = sheet.getLastRowNum();
        }
        if (n3 < 0) {
            n3 = sheet.getRow(n2).getFirstCellNum();
            for (n6 = n2; n6 <= n4; ++n6) {
                row = sheet.getRow(n6);
                if (row == null || row.getFirstCellNum() >= n3) continue;
                n3 = row.getFirstCellNum();
            }
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Start column cannot be determined!");
        }
        if (n5 < 0) {
            n5 = n3;
            for (n6 = n2; n6 <= n4; ++n6) {
                row = sheet.getRow(n6);
                if (row == null || row.getLastCellNum() - 1 <= n5) continue;
                n5 = row.getLastCellNum() - 1;
            }
        }
        return this.readData(sheet, n2, n3, n4 - n2 + 1, n5 - n3 + 1, bl);
    }

    public final DataFrame readWorksheet(int worksheetIndex, boolean header) {
        return this.readWorksheet(worksheetIndex, -1, -1, -1, -1, header);
    }

    public final DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header) {
        return this.readWorksheet(this.workbook.getSheetIndex(worksheetName), startRow, startCol, endRow, endCol, header);
    }

    public final DataFrame readWorksheet(String worksheetName, boolean header) {
        return this.readWorksheet(worksheetName, -1, -1, -1, -1, header);
    }

    /*
     * Unable to fully structure code
     */
    public final void addImage(String var1_1, String var2_2, boolean var3_3) throws FileNotFoundException, IOException {
        block16: {
            block15: {
                var4_5 = var3_3;
                var3_4 = var2_2;
                var2_2 = new File((String)var1_1);
                var1_1 = this;
                var3_4 = var1_1.getName(var3_4);
                var5_6 = var1_1.workbook.getSheet(var3_4.getSheetName());
                var3_4 = new AreaReference(var3_4.getRefersToFormula());
                var6_7 = var3_4.getFirstCell();
                var3_4 = var3_4.getLastCell();
                var7_8 = var2_2.getName().toLowerCase();
                if (var7_8.endsWith("jpg") || var7_8.endsWith("jpeg")) {
                    var7_9 = 5;
                } else if (var7_8.endsWith("png")) {
                    var7_9 = 6;
                } else if (var7_8.endsWith("wmf")) {
                    var7_9 = 3;
                } else if (var7_8.endsWith("emf")) {
                    var7_9 = 2;
                } else if (var7_8.endsWith("bmp") || var7_8.endsWith("dib")) {
                    var7_9 = 7;
                } else if (var7_8.endsWith("pict") || var7_8.endsWith("pct") || var7_8.endsWith("pic")) {
                    var7_9 = 4;
                } else {
                    throw new IllegalArgumentException("Image type not supported!");
                }
                var2_2 = new FileInputStream((File)var2_2);
                var8_10 = IOUtils.toByteArray((InputStream)var2_2);
                var7_9 = var1_1.workbook.addPicture(var8_10, var7_9);
                var2_2.close();
                if (!(var1_1.workbook instanceof HSSFWorkbook)) break block15;
                var2_2 = ((HSSFSheet)var5_6).getDrawingPatriarch();
                if (var2_2 != null) break block16;
                ** GOTO lbl-1000
            }
            if (var1_1.workbook instanceof XSSFWorkbook) {
                var2_2 = ((XSSFSheet)var5_6).createDrawingPatriarch();
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = var5_6.createDrawingPatriarch();
            }
        }
        var1_1 = var1_1.workbook.getCreationHelper().createClientAnchor();
        var1_1.setRow1(var6_7.getRow());
        var1_1.setCol1((int)var6_7.getCol());
        var1_1.setRow2(var3_4.getRow() + 1);
        var1_1.setCol2(var3_4.getCol() + 1);
        var1_1.setAnchorType(3);
        var1_1 = var2_2.createPicture((ClientAnchor)var1_1, var7_9);
        if (var4_5) {
            var1_1.resize();
        }
    }

    public final CellStyle createCellStyle(String string) {
        if (this.getCellStyle(string) == null) {
            if (this.workbook instanceof HSSFWorkbook) {
                String string2 = string;
                string = (HSSFWorkbook)this.workbook;
                HSSFCellStyle hSSFCellStyle = string.createCellStyle();
                if (string2 != null) {
                    hSSFCellStyle.setUserStyleName(string2);
                }
                return new HCellStyle((HSSFWorkbook)string, hSSFCellStyle);
            }
            if (this.workbook instanceof XSSFWorkbook) {
                String string3 = string;
                string = (XSSFWorkbook)this.workbook;
                int n = 0;
                CTXf cTXf = CTXf.Factory.newInstance();
                cTXf.setNumFmtId(0L);
                cTXf.setFontId(0L);
                cTXf.setFillId(0L);
                cTXf.setBorderId(0L);
                if (string3 != null) {
                    CTCellStyles cTCellStyles = string.getStylesSource().getCTStylesheet().getCellStyles();
                    if (cTCellStyles == null) {
                        cTCellStyles = string.getStylesSource().getCTStylesheet().addNewCellStyles();
                        cTCellStyles.setCount(0L);
                    }
                    if (cTCellStyles.getCount() == 0L) {
                        CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                        cTCellStyle.setName("Standard");
                        cTCellStyle.setXfId(0L);
                        cTCellStyle.setBuiltinId(0L);
                        cTCellStyles.setCount(1L);
                    }
                    CTXf cTXf2 = CTXf.Factory.newInstance();
                    cTXf2.setNumFmtId(0L);
                    cTXf2.setFontId(0L);
                    cTXf2.setFillId(0L);
                    cTXf2.setBorderId(0L);
                    n = string.getStylesSource().putCellStyleXf(cTXf2);
                    cTXf.setXfId((long)(n - 1));
                    CTCellStyle cTCellStyle = cTCellStyles.addNewCellStyle();
                    cTCellStyle.setName(string3);
                    cTCellStyle.setXfId((long)(n - 1));
                    cTCellStyles.setCount(cTCellStyles.getCount() + 1L);
                }
                int n2 = string.getStylesSource().putCellXf(cTXf);
                return new XCellStyle((XSSFWorkbook)string, n2 - 1, n - 1);
            }
            return null;
        }
        throw new IllegalArgumentException("Cell style with name '" + string + "' already exists!");
    }

    public final CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public final int getActiveSheetIndex() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return -1;
        }
        return this.workbook.getActiveSheetIndex();
    }

    public final String getActiveSheetName() {
        if (this.workbook.getNumberOfSheets() <= 0) {
            return null;
        }
        return this.workbook.getSheetName(this.workbook.getActiveSheetIndex());
    }

    public final void setActiveSheet(int sheetIndex) {
        this.workbook.setActiveSheet(sheetIndex);
    }

    public final void setActiveSheet(String sheetName) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.setActiveSheet(sheetIndex);
    }

    public final void hideSheet(int sheetIndex, boolean veryHidden) {
        this.setAlternativeActiveSheet(sheetIndex);
        this.workbook.setSheetHidden(sheetIndex, veryHidden ? 2 : 1);
    }

    public final void hideSheet(String sheetName, boolean veryHidden) {
        this.hideSheet(this.workbook.getSheetIndex(sheetName), veryHidden);
    }

    public final void unhideSheet(int sheetIndex) {
        this.workbook.setSheetHidden(sheetIndex, 0);
    }

    public final void unhideSheet(String sheetName) {
        this.unhideSheet(this.workbook.getSheetIndex(sheetName));
    }

    public final boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public final boolean isSheetHidden(String sheetName) {
        return this.isSheetHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public final boolean isSheetVeryHidden(String sheetName) {
        return this.isSheetVeryHidden(this.workbook.getSheetIndex(sheetName));
    }

    public final void setColumnWidth(int n, int n2, int n3) {
        Sheet sheet = this.getSheet(n);
        if (n3 >= 0) {
            sheet.setColumnWidth(n2, n3);
            return;
        }
        if (n3 == -1) {
            sheet.autoSizeColumn(n2);
            return;
        }
        sheet.setColumnWidth(n2, sheet.getDefaultColumnWidth() << 8);
    }

    public final void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.setColumnWidth(this.workbook.getSheetIndex(sheetName), columnIndex, width);
    }

    public final void setRowHeight(int n, int n2, float f) {
        Sheet sheet = this.getSheet(n);
        Row row = sheet.getRow(n2);
        if (row == null) {
            row = this.getSheet(n).createRow(n2);
        }
        if (f >= 0.0f) {
            row.setHeightInPoints(f);
            return;
        }
        row.setHeightInPoints(sheet.getDefaultRowHeightInPoints());
    }

    public final void setRowHeight(String sheetName, int rowIndex, float height) {
        this.setRowHeight(this.workbook.getSheetIndex(sheetName), rowIndex, height);
    }

    private void save(File f) throws FileNotFoundException, IOException {
        this.excelFile = f;
        FileOutputStream fos = new FileOutputStream(f, false);
        this.workbook.write((OutputStream)fos);
        fos.close();
    }

    public final void save(String file) throws FileNotFoundException, IOException {
        this.save(new File(file));
    }

    public final void save() throws FileNotFoundException, IOException {
        this.save(this.excelFile);
    }

    private Name getName(String string) {
        Name name = this.workbook.getName(string);
        if (name != null) {
            return name;
        }
        throw new IllegalArgumentException("Name '" + string + "' does not exist!");
    }

    private static boolean isValidReference(String string) {
        return string != null && !string.startsWith("#REF!") && !string.startsWith("#NULL!");
    }

    private void checkName(Name name) {
        if (!Workbook.isValidReference(name.getRefersToFormula())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' has invalid reference!");
        }
        if (!this.existsSheet(name.getSheetName())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' does not refer to a valid sheet!");
        }
    }

    private static Cell getCell(Sheet sheet, int n, int n2, boolean bl) {
        Row row = sheet.getRow(n);
        if (row == null) {
            if (bl) {
                row = sheet.createRow(n);
            } else {
                return null;
            }
        }
        if ((sheet = row.getCell(n2)) == null) {
            if (bl) {
                sheet = row.createCell(n2);
            } else {
                return null;
            }
        }
        return sheet;
    }

    private Sheet getSheet(int n) {
        if (n < 0 || n >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Sheet with index " + n + " does not exist!");
        }
        return this.workbook.getSheetAt(n);
    }

    private Sheet getSheet(String string) {
        Sheet sheet = this.workbook.getSheet(string);
        if (sheet == null) {
            throw new IllegalArgumentException("Sheet with name '" + string + "' does not exist!");
        }
        return sheet;
    }

    public final void setMissingValue(String[] values) {
        this.missingValue = values;
    }

    private void setMissing(Cell cell) {
        if (this.missingValue.length <= 0 || this.missingValue[0] == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellType(1);
        cell.setCellValue(this.missingValue[0]);
        this.setCellStyle(cell, DataFormatOnlyCellStyle.get());
    }

    private static DataType determineColumnType(ArrayList<DataType> object) {
        DataType dataType = DataType.Boolean;
        object = ((ArrayList)object).iterator();
        while (object.hasNext() && !dataType.equals((Object)DataType.String)) {
            DataType dataType2 = (DataType)((Object)object.next());
            if (dataType2.ordinal() <= dataType.ordinal()) continue;
            dataType = dataType2;
        }
        return dataType;
    }

    private void setAlternativeActiveSheet(int n) {
        if (n == this.getActiveSheetIndex()) {
            boolean bl = false;
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                if (i == n || this.workbook.isSheetHidden(i) || this.workbook.isSheetVeryHidden(i)) continue;
                this.setActiveSheet(i);
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Cannot hide or remove sheet as there would be no alternative active sheet left!");
            }
        }
    }

    public final CellStyle getCellStyle(String string) {
        if (this.workbook instanceof HSSFWorkbook) {
            String string2 = string;
            string = (HSSFWorkbook)this.workbook;
            HSSFWorkbook hSSFWorkbook = string;
            for (short s = 0; s < string.getNumCellStyles(); s = (short)(s + 1)) {
                HSSFCellStyle hSSFCellStyle = hSSFWorkbook.getCellStyleAt(s);
                if (hSSFCellStyle.getUserStyleName() == null || !hSSFCellStyle.getUserStyleName().equals(string2)) continue;
                return new HCellStyle((HSSFWorkbook)string, hSSFCellStyle);
            }
            return null;
        }
        if (this.workbook instanceof XSSFWorkbook) {
            String string3 = string;
            string = (XSSFWorkbook)this.workbook;
            CTCellStyles cTCellStyles = string.getStylesSource().getCTStylesheet().getCellStyles();
            if (cTCellStyles != null) {
                int n = 0;
                while ((long)n < cTCellStyles.getCount()) {
                    CTCellStyle cTCellStyle = cTCellStyles.getCellStyleArray(n);
                    if (cTCellStyle.getName().equals(string3)) {
                        int n2 = (int)cTCellStyle.getXfId();
                        return new XCellStyle((XSSFWorkbook)string, -1, n2);
                    }
                    ++n;
                }
            }
            return null;
        }
        return null;
    }

    private CellStyle getCellStyle(Cell cell) {
        return new SSCellStyle(this.workbook, cell.getCellStyle());
    }

    private void setCellStyle(Cell cell, CellStyle cellStyle) {
        if (cellStyle != null) {
            if (cellStyle instanceof HCellStyle) {
                HCellStyle.set((HSSFCell)cell, (HCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof XCellStyle) {
                XCellStyle.set((XSSFCell)cell, (XCellStyle)cellStyle);
                return;
            }
            if (cellStyle instanceof DataFormatOnlyCellStyle) {
                cellStyle = this.getCellStyle(cell);
                switch (cell.getCellType()) {
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
                            break;
                        }
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Numeric));
                        break;
                    }
                    case 1: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.String));
                        break;
                    }
                    case 4: {
                        cellStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.Boolean));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected cell type detected!");
                    }
                }
                SSCellStyle.set(cell, (SSCellStyle)cellStyle);
                return;
            }
            SSCellStyle.set(cell, (SSCellStyle)cellStyle);
        }
    }

    public final void setCellStyle(int n, int n2, int n3, CellStyle cellStyle) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        Cell cell = Workbook.getCell(sheet, n3, n, true);
        this.setCellStyle(cell, cellStyle);
    }

    public final void setCellStyle(String string, int n, int n2, CellStyle cellStyle) {
        int n3 = n2;
        n2 = n;
        Cell cell = Workbook.getCell(this.getSheet(string), n2, n3, true);
        this.setCellStyle(cell, cellStyle);
    }

    public final void mergeCells(int n, String string) {
        this.getSheet(n).addMergedRegion(CellRangeAddress.valueOf((String)string));
    }

    public final void mergeCells(String string, String string2) {
        this.getSheet(string).addMergedRegion(CellRangeAddress.valueOf((String)string2));
    }

    public final void unmergeCells(int n, String string) {
        Sheet sheet = this.getSheet(n);
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            if (!sheet.getMergedRegion(i).formatAsString().equals(string)) continue;
            sheet.removeMergedRegion(i);
            return;
        }
    }

    public final void unmergeCells(String sheetName, String reference) {
        this.unmergeCells(this.workbook.getSheetIndex(sheetName), reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Workbook getWorkbook(String object, boolean bl) throws FileNotFoundException, IOException, InvalidFormatException {
        if (((File)(object = new File((String)object))).exists()) {
            return new Workbook((File)object);
        }
        if (!bl) throw new FileNotFoundException("File '" + ((File)object).getName() + "' could not be found - " + "you may specify to automatically create the file if not existing.");
        String string = ((File)object).getName().toLowerCase();
        if (string.endsWith(".xls")) {
            return new Workbook((File)object, SpreadsheetVersion.EXCEL97);
        }
        if (!string.endsWith(".xlsx")) throw new IllegalArgumentException("File extension not supported! Only *.xls and *.xlsx are allowed!");
        return new Workbook((File)object, SpreadsheetVersion.EXCEL2007);
    }

    public final void setCellFormula(int n, int n2, int n3, String string) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        Workbook.getCell(sheet, n3, n, true).setCellFormula(string);
    }

    public final void setCellFormula(String string, int n, int n2, String string2) {
        int n3 = n2;
        n2 = n;
        Workbook.getCell(this.getSheet(string), n2, n3, true).setCellFormula(string2);
    }

    public final String getCellFormula(int n, int n2, int n3) {
        Sheet sheet = this.getSheet(n);
        n = n3;
        n3 = n2;
        return Workbook.getCell(sheet, n3, n, true).getCellFormula();
    }

    public final String getCellFormula(String string, int n, int n2) {
        int n3 = n2;
        n2 = n;
        return Workbook.getCell(this.getSheet(string), n2, n3, true).getCellFormula();
    }

    public final boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.getSheet(sheetIndex).getForceFormulaRecalculation();
    }

    public final boolean getForceFormulaRecalculation(String sheetName) {
        return this.getSheet(sheetName).getForceFormulaRecalculation();
    }

    public final void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.getSheet(sheetIndex).setForceFormulaRecalculation(value);
    }

    public final void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.getSheet(sheetName).setForceFormulaRecalculation(value);
    }

    public final void setAutoFilter(int n, String string) {
        this.getSheet(n).setAutoFilter(CellRangeAddress.valueOf((String)string));
    }

    public final void setAutoFilter(String string, String string2) {
        this.getSheet(string).setAutoFilter(CellRangeAddress.valueOf((String)string2));
    }

    public final int getLastRow(int sheetIndex) {
        return this.getSheet(sheetIndex).getLastRowNum();
    }

    public final int getLastRow(String sheetName) {
        return this.getSheet(sheetName).getLastRowNum();
    }

    public final void appendNamedRegion(DataFrame dataFrame, String string, boolean bl) {
        Sheet sheet = this.workbook.getSheet(this.getName(string).getSheetName());
        int[] nArray = this.getReferenceCoordinates(string);
        this.writeData(dataFrame, sheet, nArray[2] + 1, nArray[1], bl);
        int n = nArray[2] + dataFrame.rows();
        int n2 = Math.max(nArray[1] + dataFrame.columns() - 1, nArray[3]);
        String string2 = new CellRangeAddress(nArray[0], n, nArray[1], n2).formatAsString(sheet.getSheetName(), true);
        this.createName(string, string2, true);
    }

    public final void appendWorksheet(DataFrame dataFrame, int n, boolean bl) {
        int n2;
        short s;
        Sheet sheet = this.getSheet(n);
        int n22 = this.getLastRow(n);
        int s2 = Integer.MAX_VALUE;
        for (int i = 0; i < n22 && s > 0; ++i) {
            Row row = sheet.getRow(i);
            if (row == null || row.getFirstCellNum() >= s) continue;
            s = row.getFirstCellNum();
        }
        if (s == Integer.MAX_VALUE) {
            n2 = 0;
        }
        this.writeWorksheet(dataFrame, n, this.getLastRow(n) + 1, n2, bl);
    }

    public final void appendWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.appendWorksheet(data, this.workbook.getSheetIndex(worksheetName), header);
    }

    public final void clearSheet(int sheetIndex) {
        Sheet sheet = this.getSheet(sheetIndex);
        Iterator it = sheet.rowIterator();
        while (it.hasNext()) {
            sheet.removeRow((Row)it.next());
        }
    }

    public final void clearSheet(String sheetName) {
        this.clearSheet(this.workbook.getSheetIndex(sheetName));
    }

    public final class ColumnBuilder {
        ArrayList<DataType> detectedTypes;
        ArrayList<CellValue> values;
        ArrayList<CellValue> isDate = new ArrayList();
        private /* synthetic */ Workbook this$0;

        public ColumnBuilder(Workbook workbook, int n) {
            this.this$0 = workbook;
            this.detectedTypes = new ArrayList(n);
            this.values = new ArrayList(n);
        }

        public final void addMissing() {
            this.values.add(null);
            this.detectedTypes.add(DataType.Boolean);
        }

        static /* synthetic */ void access$000(ColumnBuilder columnBuilder, String string) {
            if (columnBuilder.this$0.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
                columnBuilder.values.add(null);
                columnBuilder.detectedTypes.add(DataType.Boolean);
                columnBuilder.this$0.addWarning(string);
                return;
            }
            throw new IllegalArgumentException(string);
        }

        static /* synthetic */ void access$100(ColumnBuilder columnBuilder, CellValue cellValue, DataType dataType) {
            if (DataType.DateTime.equals((Object)dataType)) {
                columnBuilder.isDate.add(cellValue);
            }
            columnBuilder.values.add(cellValue);
            columnBuilder.detectedTypes.add(dataType);
        }
    }
}

