/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public abstract class ColumnBuilder
extends Common {
    protected ArrayList<DataType> detectedTypes;
    protected ArrayList<Cell> cells;
    protected ArrayList<CellValue> values;
    protected String dateTimeFormat;
    protected boolean forceConversion;
    protected boolean takeCached = false;
    protected FormulaEvaluator evaluator = null;
    protected ErrorBehavior onErrorCell;

    public ColumnBuilder(int nrows, boolean forceConversion, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        this.detectedTypes = new ArrayList(nrows);
        this.cells = new ArrayList(nrows);
        this.values = new ArrayList(nrows);
        this.forceConversion = forceConversion;
        this.evaluator = evaluator;
        this.takeCached = evaluator == null;
        this.onErrorCell = onErrorCell;
        this.dateTimeFormat = dateTimeFormat;
    }

    public void clear() {
        this.detectedTypes.clear();
        this.cells.clear();
        this.values.clear();
    }

    public void addCell(Cell c) {
        CellValue cv;
        if (c == null) {
            this.addMissing();
            return;
        }
        if (c.getCellType() == 5 || c.getCellType() == 2 && c.getCachedFormulaResultType() == 5) {
            String msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(c.getErrorCellValue());
            this.cellError(msg);
            return;
        }
        try {
            cv = this.getCellValue(c);
        }
        catch (Exception e) {
            String msg = "Error when trying to evaluate cell " + CellUtils.formatAsString(c) + " - " + e.getMessage();
            this.cellError(msg);
            return;
        }
        if (cv == null) {
            this.addMissing();
            return;
        }
        this.handleCell(c, cv);
    }

    protected void addMissing() {
        this.values.add(null);
        this.cells.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    protected void addValue(Cell c, CellValue cv, DataType dt) {
        this.cells.add(c);
        this.values.add(cv);
        this.detectedTypes.add(dt);
    }

    public Column buildBooleanColumn() {
        boolean[] colValues = new boolean[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue();
                        break;
                    }
                    case Numeric: {
                        if (this.forceConversion) {
                            colValues[counter] = cv.getNumberValue() > 0.0;
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            colValues[counter] = Boolean.parseBoolean(cv.getStringValue().toLowerCase());
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        missing[counter] = true;
                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from DateTime to Boolean - returning NA");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, missing, DataType.Boolean);
    }

    public Column buildDateTimeColumn() {
        Date[] colValues = new Date[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        missing[counter] = true;
                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Boolean to DateTime - returning NA");
                        break;
                    }
                    case Numeric: {
                        if (this.forceConversion) {
                            if (DateUtil.isValidExcelDate((double)cv.getNumberValue())) {
                                colValues[counter] = DateUtil.getJavaDate((double)cv.getNumberValue());
                                break;
                            }
                            missing[counter] = true;
                            this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Numeric to DateTime - returning NA");
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Workbook.dateTimeFormatter.parse(cv.getStringValue(), this.dateTimeFormat);
                            }
                            catch (Exception e) {
                                missing[counter] = true;
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to DateTime - returning NA");
                            }
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = cell.getDateCellValue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, missing, DataType.DateTime);
    }

    public Column buildNumericColumn() {
        double[] colValues = new double[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue() ? 1.0 : 0.0;
                        break;
                    }
                    case Numeric: {
                        colValues[counter] = cv.getNumberValue();
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Double.parseDouble(cv.getStringValue());
                            }
                            catch (NumberFormatException e) {
                                missing[counter] = true;
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to Numeric - returning NA");
                            }
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        if (this.forceConversion) {
                            colValues[counter] = cv.getNumberValue();
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, missing, DataType.Numeric);
    }

    public Column buildStringColumn() {
        String[] colValues = new String[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        DataFormatter fmt = new DataFormatter();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: 
                    case Numeric: {
                        colValues[counter] = fmt.formatCellValue(cell, this.evaluator);
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = Workbook.dateTimeFormatter.format(DateUtil.getJavaDate((double)cv.getNumberValue()), this.dateTimeFormat);
                        break;
                    }
                    case String: {
                        colValues[counter] = cv.getStringValue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, missing, DataType.String);
    }

    protected void cellError(String msg) {
        if (!this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            throw new IllegalArgumentException(msg);
        }
        this.addMissing();
        this.addWarning(msg);
    }

    public DataType determineColumnType() {
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = this.detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            DataType dt = it.next();
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = dt;
        }
        return columnType;
    }

    protected CellValue getCachedCellValue(Cell cell) {
        int valueType = cell.getCellType();
        if (valueType == 2) {
            valueType = cell.getCachedFormulaResultType();
        }
        switch (valueType) {
            case 3: {
                return null;
            }
            case 4: {
                if (cell.getBooleanCellValue()) {
                    return CellValue.TRUE;
                }
                return CellValue.FALSE;
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getStringCellValue());
            }
            case 5: {
                return CellValue.getError((int)cell.getErrorCellValue());
            }
        }
        String msg = String.format("Could not extract value from cell with cached value type %d", valueType);
        throw new RuntimeException(msg);
    }

    protected CellValue getCellValue(Cell cell) {
        if (this.takeCached) {
            return this.getCachedCellValue(cell);
        }
        this.evaluator.evaluateFormulaCell(cell);
        return this.evaluator.evaluate(cell);
    }

    protected abstract void handleCell(Cell var1, CellValue var2);
}

