/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public final class RDataFrameWrapper {
    final DataFrame dataFrame;

    public RDataFrameWrapper() {
        this.dataFrame = new DataFrame();
    }

    /*
     * WARNING - void declaration
     */
    public RDataFrameWrapper(DataFrame dataFrame) {
        void var1_1;
        this.dataFrame = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addNumericColumn(String name, double[] column, boolean[] na) {
        void var1_1;
        Double[] elements = new Double[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : new Double(column[i]);
        }
        ArrayList<Double> v = new ArrayList<Double>(Arrays.asList(elements));
        this.dataFrame.addColumn((String)var1_1, DataType.Numeric, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBooleanColumn(String name, boolean[] column, boolean[] na) {
        void var1_1;
        Boolean[] elements = new Boolean[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : new Boolean(column[i]);
        }
        ArrayList<Boolean> v = new ArrayList<Boolean>(Arrays.asList(elements));
        this.dataFrame.addColumn((String)var1_1, DataType.Boolean, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void addStringColumn(String name, String[] column, boolean[] na) {
        void var1_1;
        void var2_2;
        for (int i = 0; i < column.length; ++i) {
            if (!na[i]) continue;
            column[i] = null;
        }
        ArrayList v = new ArrayList(Arrays.asList(var2_2));
        this.dataFrame.addColumn((String)var1_1, DataType.String, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void addDateTimeColumn(String name, String[] column, boolean[] na) {
        void var1_1;
        Date[] elements = new Date[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : Workbook.dateTimeFormatter.parse(column[i], "%Y-%m-%d %H:%M:%S");
        }
        ArrayList<Date> v = new ArrayList<Date>(Arrays.asList(elements));
        this.dataFrame.addColumn((String)var1_1, DataType.DateTime, v);
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getColumnTypes() {
        void var2_2;
        ArrayList<DataType> columnTypes = this.dataFrame.getColumnTypes();
        String[] dataTypes = new String[columnTypes.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            dataTypes[i] = columnTypes.get(i).toString();
        }
        return var2_2;
    }

    public final String[] getColumnNames() {
        ArrayList<String> arrayList = this.dataFrame.getColumnNames();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public final double[] getNumericColumn(int col) {
        void var2_3;
        ArrayList v = this.dataFrame.getColumn(col);
        double[] values = new double[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Double d = (Double)v.get(i);
            values[i] = d == null ? 0.0 : d;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getStringColumn(int col) {
        void var1_1;
        ArrayList arrayList = this.dataFrame.getColumn((int)var1_1);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean[] getBooleanColumn(int col) {
        void var2_3;
        ArrayList v = this.dataFrame.getColumn(col);
        boolean[] values = new boolean[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Boolean b = (Boolean)v.get(i);
            values[i] = b == null ? false : b;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getDateTimeColumn(int col) {
        void var2_3;
        ArrayList v = this.dataFrame.getColumn(col);
        String[] values = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Date d = (Date)v.get(i);
            values[i] = d == null ? null : Workbook.dateTimeFormatter.format(d, "%Y-%m-%d %H:%M:%S");
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean[] isMissing(int col) {
        void var2_3;
        ArrayList v = this.dataFrame.getColumn(col);
        boolean[] missing = new boolean[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            missing[i] = v.get(i) == null;
        }
        return var2_3;
    }
}

