/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.Iterator;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Pxg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;

public final class XSSFFormulaUtils {
    private final XSSFWorkbook _wb;
    private final XSSFEvaluationWorkbook _fpwb;

    public XSSFFormulaUtils(XSSFWorkbook wb) {
        this._wb = wb;
        this._fpwb = XSSFEvaluationWorkbook.create(this._wb);
    }

    public void updateSheetName(int sheetIndex, String oldName, String newName) {
        for (int i = 0; i < this._wb.getNumberOfNames(); ++i) {
            XSSFName nm = this._wb.getNameAt(i);
            if (nm.getSheetIndex() != -1 && nm.getSheetIndex() != sheetIndex) continue;
            this.updateName(nm, oldName, newName);
        }
        for (XSSFSheet sh : this._wb) {
            Iterator i$ = sh.iterator();
            while (i$.hasNext()) {
                Row row = (Row)i$.next();
                for (Cell cell : row) {
                    if (cell.getCellType() != 2) continue;
                    this.updateFormula((XSSFCell)cell, oldName, newName);
                }
            }
        }
    }

    private void updateFormula(XSSFCell cell, String oldName, String newName) {
        String formula;
        CTCellFormula f = cell.getCTCell().getF();
        if (f != null && (formula = f.getStringValue()) != null && formula.length() > 0) {
            Ptg[] ptgs;
            int sheetIndex = this._wb.getSheetIndex(cell.getSheet());
            for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)this._fpwb, (int)0, (int)sheetIndex)) {
                this.updatePtg(ptg, oldName, newName);
            }
            String updatedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)this._fpwb, (Ptg[])ptgs);
            if (!formula.equals(updatedFormula)) {
                f.setStringValue(updatedFormula);
            }
        }
    }

    private void updateName(XSSFName name, String oldName, String newName) {
        String formula = name.getRefersToFormula();
        if (formula != null) {
            Ptg[] ptgs;
            int sheetIndex = name.getSheetIndex();
            for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)this._fpwb, (int)4, (int)sheetIndex)) {
                this.updatePtg(ptg, oldName, newName);
            }
            String updatedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)this._fpwb, (Ptg[])ptgs);
            if (!formula.equals(updatedFormula)) {
                name.setRefersToFormula(updatedFormula);
            }
        }
    }

    private void updatePtg(Ptg ptg, String oldName, String newName) {
        Pxg pxg;
        if (ptg instanceof Pxg && (pxg = (Pxg)ptg).getExternalWorkbookNumber() < 1 && pxg.getSheetName().equals(oldName)) {
            pxg.setSheetName(newName);
        }
    }
}

