/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.utils.RepeatableIterable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SimpleSequence<T>
implements RepeatableIterable<T> {
    private final T[] values;

    public static SimpleSequence<String> create(String[] values) {
        return new SimpleSequence<String>(values);
    }

    public static SimpleSequence<Integer> create(int[] values) {
        Integer[] newValues = (Integer[])Arrays.stream(values).boxed().toArray(Integer[]::new);
        return new SimpleSequence<Integer>(newValues);
    }

    public static SimpleSequence<Double> create(double[] values) {
        Double[] newValues = (Double[])Arrays.stream(values).boxed().toArray(Double[]::new);
        return new SimpleSequence<Double>(newValues);
    }

    public SimpleSequence(T[] values) {
        this.values = values;
    }

    @Override
    public Iterator<T> iterator(boolean repeating) {
        return new SequenceIterator(repeating);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    private final class SequenceIterator
    implements Iterator<T> {
        private final boolean repeating;
        private int i = 0;

        public SequenceIterator(boolean repeating) {
            this.repeating = repeating;
        }

        @Override
        public boolean hasNext() {
            return this.repeating || this.i < SimpleSequence.this.values.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = SimpleSequence.this.values[this.i % SimpleSequence.this.values.length];
            ++this.i;
            return result;
        }
    }
}

