/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXSSFSheet
implements Sheet,
Cloneable {
    SXSSFWorkbook _workbook;
    XSSFSheet _sh;
    TreeMap<Integer, SXSSFRow> _rows = new TreeMap();
    SheetDataWriter _writer;
    int _randomAccessWindowSize = 5000;

    public SXSSFSheet(SXSSFWorkbook workbook, XSSFSheet xSheet) throws IOException {
        this._workbook = workbook;
        this._sh = xSheet;
        this._writer = new SheetDataWriter();
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        this.flushRows(0);
        return this._writer.getWorksheetXMLInputStream();
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    public Row createRow(int rownum) {
        Row previousRow = rownum > 0 ? this.getRow(rownum - 1) : null;
        int initialAllocationSize = 0;
        if (previousRow != null) {
            initialAllocationSize = previousRow.getLastCellNum();
        }
        if (initialAllocationSize <= 0 && this._writer.getNumberOfFlushedRows() > 0) {
            initialAllocationSize = this._writer.getNumberOfCellsOfLastFlushedRow();
        }
        if (initialAllocationSize <= 0) {
            initialAllocationSize = 10;
        }
        SXSSFRow newRow = new SXSSFRow(this, initialAllocationSize);
        this._rows.put(new Integer(rownum), newRow);
        if (this._randomAccessWindowSize >= 0 && this._rows.size() > this._randomAccessWindowSize) {
            try {
                this.flushRows(this._randomAccessWindowSize);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return newRow;
    }

    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        Iterator<Map.Entry<Integer, SXSSFRow>> iter = this._rows.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, SXSSFRow> entry = iter.next();
            if (entry.getValue() != row) continue;
            iter.remove();
            return;
        }
    }

    public Row getRow(int rownum) {
        return this._rows.get(new Integer(rownum));
    }

    public int getPhysicalNumberOfRows() {
        return this._rows.size() + this._writer.getNumberOfFlushedRows();
    }

    public int getFirstRowNum() {
        if (this._writer.getNumberOfFlushedRows() > 0) {
            return this._writer.getLowestIndexOfFlushedRows();
        }
        return this._rows.size() == 0 ? 0 : this._rows.firstKey();
    }

    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.lastKey();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sh.setColumnHidden(columnIndex, hidden);
    }

    public boolean isColumnHidden(int columnIndex) {
        return this._sh.isColumnHidden(columnIndex);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this._sh.setColumnWidth(columnIndex, width);
    }

    public int getColumnWidth(int columnIndex) {
        return this._sh.getColumnWidth(columnIndex);
    }

    public void setDefaultColumnWidth(int width) {
        this._sh.setDefaultColumnWidth(width);
    }

    public int getDefaultColumnWidth() {
        return this._sh.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this._sh.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this._sh.getDefaultRowHeightInPoints();
    }

    public void setDefaultRowHeight(short height) {
        this._sh.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this._sh.setDefaultRowHeightInPoints(height);
    }

    public CellStyle getColumnStyle(int column) {
        return this._sh.getColumnStyle(column);
    }

    public int addMergedRegion(CellRangeAddress region) {
        return this._sh.addMergedRegion(region);
    }

    public void setVerticallyCenter(boolean value) {
        this._sh.setVerticallyCenter(value);
    }

    public void setHorizontallyCenter(boolean value) {
        this._sh.setHorizontallyCenter(value);
    }

    public boolean getHorizontallyCenter() {
        return this._sh.getHorizontallyCenter();
    }

    public boolean getVerticallyCenter() {
        return this._sh.getVerticallyCenter();
    }

    public void removeMergedRegion(int index) {
        this._sh.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this._sh.getNumMergedRegions();
    }

    public CellRangeAddress getMergedRegion(int index) {
        return this._sh.getMergedRegion(index);
    }

    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this._rows.values().iterator();
        return result;
    }

    public void setAutobreaks(boolean value) {
        this._sh.setAutobreaks(value);
    }

    public void setDisplayGuts(boolean value) {
        this._sh.setDisplayGuts(value);
    }

    public void setDisplayZeros(boolean value) {
        this._sh.setDisplayZeros(value);
    }

    public boolean isDisplayZeros() {
        return this._sh.isDisplayZeros();
    }

    public void setFitToPage(boolean value) {
        this._sh.setFitToPage(value);
    }

    public void setRowSumsBelow(boolean value) {
        this._sh.setRowSumsBelow(value);
    }

    public void setRowSumsRight(boolean value) {
        this._sh.setRowSumsRight(value);
    }

    public boolean getAutobreaks() {
        return this._sh.getAutobreaks();
    }

    public boolean getDisplayGuts() {
        return this._sh.getDisplayGuts();
    }

    public boolean getFitToPage() {
        return this._sh.getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return this._sh.getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return this._sh.getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this._sh.isPrintGridlines();
    }

    public void setPrintGridlines(boolean show) {
        this._sh.setPrintGridlines(show);
    }

    public PrintSetup getPrintSetup() {
        return this._sh.getPrintSetup();
    }

    public Header getHeader() {
        return this._sh.getHeader();
    }

    public Footer getFooter() {
        return this._sh.getFooter();
    }

    public void setSelected(boolean value) {
        this._sh.setSelected(value);
    }

    public double getMargin(short margin) {
        return this._sh.getMargin(margin);
    }

    public void setMargin(short margin, double size) {
        this._sh.setMargin(margin, size);
    }

    public boolean getProtect() {
        return this._sh.getProtect();
    }

    public void protectSheet(String password) {
        this._sh.protectSheet(password);
    }

    public boolean getScenarioProtect() {
        return this._sh.getScenarioProtect();
    }

    public void setZoom(int numerator, int denominator) {
        this._sh.setZoom(numerator, denominator);
    }

    public short getTopRow() {
        return this._sh.getTopRow();
    }

    public short getLeftCol() {
        return this._sh.getLeftCol();
    }

    public void showInPane(short toprow, short leftcol) {
        this._sh.showInPane(toprow, leftcol);
    }

    public void setForceFormulaRecalculation(boolean value) {
        this._sh.setForceFormulaRecalculation(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this._sh.getForceFormulaRecalculation();
    }

    public void shiftRows(int startRow, int endRow, int n) {
        throw new RuntimeException("NotImplemented");
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        throw new RuntimeException("NotImplemented");
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this._sh.createFreezePane(colSplit, rowSplit, leftmostColumn, topRow);
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this._sh.createFreezePane(colSplit, rowSplit);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this._sh.createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    public PaneInformation getPaneInformation() {
        return this._sh.getPaneInformation();
    }

    public void setDisplayGridlines(boolean show) {
        this._sh.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this._sh.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this._sh.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this._sh.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this._sh.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this._sh.isDisplayRowColHeadings();
    }

    public void setRowBreak(int row) {
        this._sh.setRowBreak(row);
    }

    public boolean isRowBroken(int row) {
        return this._sh.isRowBroken(row);
    }

    public void removeRowBreak(int row) {
        this._sh.removeRowBreak(row);
    }

    public int[] getRowBreaks() {
        return this._sh.getRowBreaks();
    }

    public int[] getColumnBreaks() {
        return this._sh.getColumnBreaks();
    }

    public void setColumnBreak(int column) {
        this._sh.setColumnBreak(column);
    }

    public boolean isColumnBroken(int column) {
        return this._sh.isColumnBroken(column);
    }

    public void removeColumnBreak(int column) {
        this._sh.removeColumnBreak(column);
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sh.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this._sh.groupColumn(fromColumn, toColumn);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sh.ungroupColumn(fromColumn, toColumn);
    }

    public void groupRow(int fromRow, int toRow) {
        this._sh.groupRow(fromRow, toRow);
    }

    public void ungroupRow(int fromRow, int toRow) {
        this._sh.ungroupRow(fromRow, toRow);
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        this._sh.setRowGroupCollapsed(row, collapse);
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sh.setDefaultColumnStyle(column, style);
    }

    public void autoSizeColumn(int column) {
        this._sh.autoSizeColumn(column);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        this._sh.autoSizeColumn(column, useMergedCells);
    }

    public Comment getCellComment(int row, int column) {
        return this._sh.getCellComment(row, column);
    }

    public Drawing createDrawingPatriarch() {
        return this._sh.createDrawingPatriarch();
    }

    public Workbook getWorkbook() {
        return this._workbook;
    }

    public String getSheetName() {
        return this._sh.getSheetName();
    }

    public boolean isSelected() {
        return this._sh.isSelected();
    }

    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        return this._sh.setArrayFormula(formula, range);
    }

    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return this._sh.removeArrayFormula(cell);
    }

    public DataValidationHelper getDataValidationHelper() {
        return this._sh.getDataValidationHelper();
    }

    public void addValidationData(DataValidation dataValidation) {
        this._sh.addValidationData(dataValidation);
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        return this._sh.setAutoFilter(range);
    }

    void setRandomAccessWindowSize(int value) {
        assert (value != 0);
        this._randomAccessWindowSize = value;
    }

    void flushRows(int remaining) throws IOException {
        while (this._rows.size() > remaining) {
            this.flushOneRow();
        }
    }

    private void flushOneRow() throws IOException {
        Map.Entry<Integer, SXSSFRow> firstEntry = this._rows.firstEntry();
        if (firstEntry != null) {
            SXSSFRow row = firstEntry.getValue();
            int rowIndex = firstEntry.getKey();
            this._writer.writeRow(rowIndex, row);
            this._rows.remove(firstEntry.getKey());
        }
    }

    public void changeRowNum(SXSSFRow row, int newRowNum) {
        this.removeRow(row);
        this._rows.put(new Integer(newRowNum), row);
    }

    public int getRowNum(SXSSFRow row) {
        for (Map.Entry<Integer, SXSSFRow> entry : this._rows.entrySet()) {
            if (entry.getValue() != row) continue;
            return entry.getKey();
        }
        assert (false);
        return -1;
    }

    public class SheetDataWriter {
        private final File _fd = File.createTempFile("sheet", ".xml");
        private final Writer _out;
        private int _rownum;
        private boolean _rowContainedNullCells = false;
        int _numberOfFlushedRows;
        int _lowestIndexOfFlushedRows;
        int _numberOfCellsOfLastFlushedRow;

        public SheetDataWriter() throws IOException {
            this._fd.deleteOnExit();
            this._out = new FileWriter(this._fd);
            this._out.write("<sheetData>\n");
        }

        public int getNumberOfFlushedRows() {
            return this._numberOfFlushedRows;
        }

        public int getNumberOfCellsOfLastFlushedRow() {
            return this._numberOfCellsOfLastFlushedRow;
        }

        public int getLowestIndexOfFlushedRows() {
            return this._lowestIndexOfFlushedRows;
        }

        protected void finalize() throws Throwable {
            this._fd.delete();
        }

        public InputStream getWorksheetXMLInputStream() throws IOException {
            this._out.write("</sheetData>");
            this._out.close();
            return new FileInputStream(this._fd);
        }

        public void writeRow(int rownum, SXSSFRow row) throws IOException {
            if (this._numberOfFlushedRows == 0) {
                this._lowestIndexOfFlushedRows = rownum;
            }
            this._numberOfCellsOfLastFlushedRow = row.getLastCellNum();
            ++this._numberOfFlushedRows;
            this.beginRow(rownum, row);
            Iterator<Cell> cells = row.allCellsIterator();
            int columnIndex = 0;
            while (cells.hasNext()) {
                this.writeCell(columnIndex++, cells.next());
            }
            this.endRow();
        }

        void beginRow(int rownum, SXSSFRow row) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\"");
            if (row.hasCustomHeight()) {
                this._out.write(" customHeight=\"true\"  ht=\"" + row.getHeightInPoints() + "\"");
            }
            if (row.getZeroHeight()) {
                this._out.write(" hidden=\"true\"");
            }
            this._out.write(">\n");
            this._rownum = rownum;
            this._rowContainedNullCells = false;
        }

        void endRow() throws IOException {
            this._out.write("</row>\n");
        }

        public void writeCell(int columnIndex, Cell cell) throws IOException {
            if (cell == null) {
                this._rowContainedNullCells = true;
                return;
            }
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\"");
            CellStyle cellStyle = cell.getCellStyle();
            if (cellStyle.getIndex() != 0) {
                this._out.write(" s=\"" + cellStyle.getIndex() + "\"");
            }
            int cellType = cell.getCellType();
            switch (cellType) {
                case 3: {
                    this._out.write(">");
                    break;
                }
                case 2: {
                    this._out.write(">");
                    this._out.write("<f>");
                    this.outputQuotedString(cell.getCellFormula());
                    this._out.write("</f>");
                    switch (cell.getCachedFormulaResultType()) {
                        case 0: {
                            double nval = cell.getNumericCellValue();
                            if (Double.isNaN(nval)) break;
                            this._out.write("<v>" + nval + "</v>");
                        }
                    }
                    break;
                }
                case 1: {
                    this._out.write(" t=\"inlineStr\">");
                    this._out.write("<is><t>");
                    this.outputQuotedString(cell.getStringCellValue());
                    this._out.write("</t></is>");
                    break;
                }
                case 0: {
                    this._out.write(" t=\"n\">");
                    this._out.write("<v>" + cell.getNumericCellValue() + "</v>");
                    break;
                }
                case 4: {
                    this._out.write(" t=\"b\">");
                    this._out.write("<v>" + (cell.getBooleanCellValue() ? "1" : "0") + "</v>");
                    break;
                }
                case 5: {
                    FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                    this._out.write(" t=\"e\">");
                    this._out.write("<v>" + error.getString() + "</v>");
                    break;
                }
                default: {
                    assert (false);
                    throw new RuntimeException("Huh?");
                }
            }
            this._out.write("</c>");
        }

        protected void outputQuotedString(String s) throws IOException {
            char[] chars = s.toCharArray();
            int last = 0;
            int length = s.length();
            block10: for (int counter = 0; counter < length; ++counter) {
                char c = chars[counter];
                switch (c) {
                    case '<': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        last = counter + 1;
                        this._out.write("&lt;");
                        continue block10;
                    }
                    case '>': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        last = counter + 1;
                        this._out.write("&gt;");
                        continue block10;
                    }
                    case '&': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        last = counter + 1;
                        this._out.write("&amp;");
                        continue block10;
                    }
                    case '\"': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        last = counter + 1;
                        this._out.write("&quot;");
                        continue block10;
                    }
                    case '\n': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        this._out.write("&#xa;");
                        last = counter + 1;
                        continue block10;
                    }
                    case '\t': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        this._out.write("&#x9;");
                        last = counter + 1;
                        continue block10;
                    }
                    case '\r': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        this._out.write("&#xd;");
                        last = counter + 1;
                        continue block10;
                    }
                    case '\u00a0': {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        this._out.write("&nbsp;");
                        last = counter + 1;
                        continue block10;
                    }
                    default: {
                        if (c >= ' ' && c <= '\u007f') continue block10;
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        last = counter + 1;
                        this._out.write("&#");
                        this._out.write(String.valueOf((int)c));
                        this._out.write(";");
                    }
                }
            }
            if (last < length) {
                this._out.write(chars, last, length - last);
            }
        }
    }
}

