/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import org.apache.poi.xslf.usermodel.LineDecoration;
import org.apache.poi.xslf.usermodel.LineEndLength;
import org.apache.poi.xslf.usermodel.LineEndWidth;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnectorNonVisual;

public class XSLFConnectorShape
extends XSLFSimpleShape {
    XSLFConnectorShape(CTConnector shape, XSLFSheet sheet) {
        super((XmlObject)shape, sheet);
    }

    static CTConnector prototype(int shapeId) {
        CTConnector ct = CTConnector.Factory.newInstance();
        CTConnectorNonVisual nvSpPr = ct.addNewNvCxnSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("Connector " + shapeId);
        cnv.setId((long)(shapeId + 1));
        nvSpPr.addNewCNvCxnSpPr();
        nvSpPr.addNewNvPr();
        CTShapeProperties spPr = ct.addNewSpPr();
        CTPresetGeometry2D prst = spPr.addNewPrstGeom();
        prst.setPrst(STShapeType.LINE);
        prst.addNewAvLst();
        CTLineProperties ln = spPr.addNewLn();
        return ct;
    }

    public void setLineHeadDecoration(LineDecoration style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineDecoration getLineHeadDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetHeadEnd()) {
            return LineDecoration.NONE;
        }
        STLineEndType.Enum end = ln.getHeadEnd().getType();
        return end == null ? LineDecoration.NONE : LineDecoration.values()[end.intValue() - 1];
    }

    public void setLineHeadWidth(LineEndWidth style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineEndWidth getLineHeadWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetHeadEnd()) {
            return null;
        }
        STLineEndWidth.Enum w = ln.getHeadEnd().getW();
        return w == null ? null : LineEndWidth.values()[w.intValue() - 1];
    }

    public void setLineHeadLength(LineEndLength style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineEndLength getLineHeadLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetHeadEnd()) {
            return null;
        }
        STLineEndLength.Enum len = ln.getHeadEnd().getLen();
        return len == null ? null : LineEndLength.values()[len.intValue() - 1];
    }

    public void setLineTailDecoration(LineDecoration style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineDecoration getLineTailDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetTailEnd()) {
            return LineDecoration.NONE;
        }
        STLineEndType.Enum end = ln.getTailEnd().getType();
        return end == null ? LineDecoration.NONE : LineDecoration.values()[end.intValue() - 1];
    }

    public void setLineTailWidth(LineEndWidth style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineEndWidth getLineTailWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetTailEnd()) {
            return null;
        }
        STLineEndWidth.Enum w = ln.getTailEnd().getW();
        return w == null ? null : LineEndWidth.values()[w.intValue() - 1];
    }

    public void setLineTailLength(LineEndLength style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt((int)(style.ordinal() + 1)));
        }
    }

    public LineEndLength getLineTailLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (!ln.isSetTailEnd()) {
            return null;
        }
        STLineEndLength.Enum len = ln.getTailEnd().getLen();
        return len == null ? null : LineEndLength.values()[len.intValue() - 1];
    }
}

