% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_observations.R
\name{parse_observations}
\alias{parse_observations}
\title{Pre-process training and experimental data from wide-format to long-format}
\usage{
parse_observations(
  x,
  subject_col,
  meas_col,
  tlen_col = NULL,
  image_col,
  barometer_col = NULL,
  laser_col = NULL,
  flen_col,
  iwidth_col,
  swidth_col,
  uas_col,
  timepoint_col = NULL,
  alt_conversion_col = NULL
)
}
\arguments{
\item{x}{Wide-format \code{data.frame} describing images and measurements}

\item{subject_col}{column name in \code{x} for subject IDs}

\item{meas_col}{character vector of column names in \code{x} with 
pixel-counts for each measurement of a subject}

\item{tlen_col}{column name in \code{x} with the true length value (i.e., in 
meters) of a measurement; primarily used to specify the true length value 
for an observation of a calibration object.  If \code{NULL}, then no true 
length will be associated with the measurement.}

\item{image_col}{column name in \code{x} containing names of images from 
which measurements are taken}

\item{barometer_col}{column name in \code{x} with Barometer altimeter values}

\item{laser_col}{column name in \code{x} with Laser altimeter values}

\item{flen_col}{column name in \code{x} with camera focal lengths (mm)}

\item{iwidth_col}{column name in \code{x} with image widths (pixels)}

\item{swidth_col}{column name in \code{x} with camera sensor widths (mm)}

\item{uas_col}{column names in \code{x} with UAS name or ID}

\item{timepoint_col}{column name in \code{x} with a timepoint value of a 
measurement.  If \code{NULL}, then all measurements are assumed to be at 
the same timepoint, or equivalently, that time does not matter for the 
analysis}

\item{alt_conversion_col}{if not \code{NULL}, column name in \code{x} with 
an altitude used to convert measurement columns from lengths to pixels}
}
\value{
outputs a list with four elements: 
\describe{
 \item{pixel_counts}{a tibble containing the measurements in pixels 
 linked with Subject, Measurement description, Image, and the Timepoint}
 \item{training_objects}{a tibble containing the Subject, Measurement, Length, 
 and Timepoint. NULL if no training objects were included}
 \item{prediction_objects}{a tibble containing the Subject, Measurement, and 
 Timepoint. NULL if no prediction data included}
 \item{image_info}{a tibble containing the Image, Barometer, Laser, FocalLength,
 ImageWidth, SensorWidth, and UAS}
 }
}
\description{
Photogrammetric data are often recorded in a wide-format \code{data.frame}, 
in which each row contains all measurement information for a single animal.
The row contains the image information (i.e., observed altitude and sensor 
information) as well as all measurements for a given subject. This function
parses the wide-format data into a normalized \code{list} of 
\code{data.frame} objects that separately describe the image and measurement 
data.  This function can process observations of calibration data as well as 
experimental data.
}
\examples{
# load example wide-format data
data("calibration")
data("whales")

# parse calibration study
calibration_data = parse_observations(
  x = calibration, 
  subject_col = 'CO.ID',
  meas_col = 'Lpix', 
  tlen_col = 'CO.L', 
  image_col = 'image', 
  barometer_col = 'Baro_Alt',
  laser_col = 'Laser_Alt', 
  flen_col = 'Focal_Length', 
  iwidth_col = 'Iw', 
  swidth_col = 'Sw',
  uas_col = 'uas'
)

# parse field study
whale_data = parse_observations(
  x = whales, 
  subject_col = 'whale_ID',
  meas_col = 'TL.pix', 
  image_col = 'Image', 
  barometer_col = 'AltitudeBarometer',
  laser_col = 'AltitudeLaser', 
  flen_col = 'FocalLength', 
  iwidth_col = 'ImageWidth', 
  swidth_col = 'SensorWidth', 
  uas_col = 'UAS',
  timepoint_col = 'year'
)

# combine parsed calibration and observation (whale) data
combined_data = combine_observations(calibration_data, whale_data)
}
