% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventCoverage.R
\name{EventCoverage}
\alias{EventCoverage}
\title{Generation of Zeta Plot.}
\usage{
EventCoverage(ZscoreVal, negGene, posGene, binNum, combine = TRUE)
}
\arguments{
\item{ZscoreVal}{zscore value}

\item{negGene}{negative control dataset, the siRNAs/genes used as negative controls in screening.}

\item{posGene}{positive control dataset, the siRNAs/genes used as positive controls in screening.}

\item{binNum}{bin number}

\item{combine}{combine two direction zeta together(TRUE or FALSE),default FALSE}
}
\value{
A list of data.frames and plots, the data.frame includes 'ZseqList', 'EC_N_I', 'EC_N_D', 'EC_P_I' and 'EC_P_D'. The plot 'EC_jitter_D' and 'EC_jitter_I' are the zeta plot for positive and negative samples.'ZseqList', 'EC_N_I', 'EC_N_D', 'EC_P_I' and 'EC_P_D' are the inputfiles for zeta plot and SVM.R. ZseqList describs the bin size in the zeta plot.
}
\description{
A zeta plot is generated from the input Z-score matrix. Zeta plot labels: x-axis: Z-score cutoffs, y-axis: the percentage of readouts that survived at a given Z-score cutoff over the total scored readouts. In order to generate this plot, the range of Z-scores is determined by ranking the absolute value of Zij (Z-score value in row i and column j) from the smallest to the largest. Z-cutoffs next are selected in the range of (-|Znxmx0.9999|, -2) to (2, |Znxmx0.9999|) to excluded the insignificant changes that may result from experimental noise( |Z| < 2, which equals to p-value >0.05). Then, for all Zij within the selected range (both positive range and negative range), the range is divided equally into x bins (the recommended input of x is 100). Thus, the percentage of readouts scored above the Z-cutoff in each bin is determined.
}
\examples{
data(countMat)
data(negGene)
data(posGene)
ZscoreVal <- Zscore(countMat,negGene)
ECList <- EventCoverage(ZscoreVal,negGene,posGene,binNum=100,combine=TRUE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
