% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_diamonds.R
\name{canvas_diamonds}
\alias{canvas_diamonds}
\title{Paint A Diamond on Canvas}
\usage{
canvas_diamonds(colors, background = '#fafafa', col.line = 'black', 
                radius = 10, alpha = 1, p = 0.2, 
                width = 500, height = 500)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the strokes.}

\item{background}{a character specifying the color used for the background.}

\item{col.line}{color of the lines.}

\item{radius}{radius of the diamonds.}

\item{alpha}{transparency of the diamonds. If \code{NULL}, added layers become increasingly more transparent.}

\item{p}{takeover probability.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many diamonds on the canvas and places two lines behind them. The diamonds can be transparent or have a random color sampled from the input.
}
\examples{
\donttest{
set.seed(1)
canvas_diamonds(colors = colorPalette('house'), radius = 10)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
