% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_lissajous.R
\name{canvas_lissajous}
\alias{canvas_lissajous}
\title{Draw a Lissajous Curve}
\usage{
canvas_lissajous(
  colors,
  background = "#000000",
  iterations = 2,
  neighbors = 50,
  noise = FALSE
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{neighbors}{a positive integer specifying the number of neighbors a block considers when drawing the connections.}

\item{noise}{logical. Whether to add perlin noise to the coordinates of the nodes.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws lissajous curves with points connected via a k-nearest neighbor approach.
}
\examples{
\donttest{
set.seed(13)

# Simple example
canvas_lissajous(colors = colorPalette("blossom"))
}

}
\references{
\url{https://en.wikipedia.org/wiki/Lissajous_curve}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
