% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processImage.R
\name{processImage}
\alias{processImage}
\title{Process Image}
\usage{
processImage(file_path = "", language = "English",
  profile = "documentConversion", textType = "normal",
  imageSource = "auto", correctOrientation = "true", correctSkew = "true",
  readBarcodes = "false", exportFormat = "txt", description = "",
  pdfPassword = "", ...)
}
\arguments{
\item{file_path}{path to the document}

\item{language}{optional, default: English}

\item{profile}{optional, default: documentConversion}

\item{textType}{optional, default: normal}

\item{imageSource}{optional, default: auto}

\item{correctOrientation}{optional, default: true}

\item{correctSkew}{optional, default: true}

\item{readBarcodes}{optional, default: false}

\item{exportFormat}{optional, default: txt; 
options: txt, txtUnstructured, rtf, docx, xlsx, pptx, pdfSearchable, pdfTextAndImages, pdfa, xml, xmlForCorrectedImage, alto}

\item{description}{optional, default: ""}

\item{pdfPassword}{optional, default: NULL}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_POST}}.}
}
\value{
Data frame with details of the task associated with the submitted Image
}
\description{
This function processes an image
}
\examples{
\dontrun{
processImage(file_path="file_path", language="English", exportFormat="txtUnstructured")
}
}
\references{
\url{http://ocrsdk.com/documentation/specifications/image-formats/}

\url{http://ocrsdk.com/documentation/apireference/processImage/}
}

