\docType{data}
\name{Pufferfish}
\alias{Pufferfish}
\title{Pufferfish Mimicry}
\format{A data frame with 20 observations on the following 2 variables.
\describe{ \item{resemblance}{a numeric vector}
\item{predators}{a numeric vector} }}
\source{
  Caley, M.J. and D. Schluter. 2003. Predators favour
  mimicry in a tropical reef fish. \emph{Proceedings of the
  Royal Society of London Series B, Biological Sciences}
  270: 667-672.
}
\description{
  Number of \code{predators} approaching models painted to
  resemble pufferfish (\emph{Canthigaster valentini})
  across a range of similarities (\code{resemblance})
}
\examples{
data(Pufferfish)
str(Pufferfish)
xyplot(predators ~ jitter(resemblance, amount = 0.1), Pufferfish)
Pufferfish
}
\references{
  \url{http://rspb.royalsocietypublishing.org/content/270/1516/667.full.pdf}

  \url{http://en.wikipedia.org/wiki/Canthigaster_valentini}

  \url{http://www.fishbase.org/Summary/SpeciesSummary.php?id=6544}
}
\keyword{datasets}

