% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprior.R
\name{dprior}
\alias{dprior}
\title{Prior Density}
\usage{
dprior(x1, x2 = NULL, prior_par = list(mu_psi = 0, sigma_psi = 1,
  mu_beta = 0, sigma_beta = 1), what = "logor", hypothesis = "H1")
}
\arguments{
\item{x1}{numeric vector with values at which the prior density should be
evaluated.}

\item{x2}{if \code{what = "p1p2"}, value of p2 (i.e., the latent "success"
probability in the experimental condition) at which the joint prior density
should be evaluated. If \code{what = "p2givenp1"}, the given value of p1
(i.e., the latent "success" probability in the control condition).}

\item{prior_par}{list with prior parameters. This list needs to contain the
following elements: \code{mu_psi} (prior mean for the normal prior on the
test-relevant log odds ratio), \code{sigma_psi} (prior standard deviation
for the normal prior on the test-relevant log odds ratio), \code{mu_beta}
(prior mean for the normal prior on the grand mean of the log odds),
\code{sigma_beta} (prior standard deviation for the normal prior on the
grand mean of the log odds). Each of the elements needs to be a real number
(the standard deviations need to be positive). The default are standard
normal priors for both the log odds ratio parameter and the grand mean of
the log odds parameter.}

\item{what}{character specifying for which quantity the prior density should
be evaluated. Either \code{"logor"} (i.e., log odds ratio) , \code{"or"}
(i.e., odds ratio), \code{"p1p2"} (i.e., the joint density of the latent
"success" probability in the experimental and control condition),
\code{"p1"} (i.e., latent "success" probability in the control condition),
\code{"p2"} (i.e., latent "success" probability in the experimental
condition), \code{"p2givenp1"} (i.e., conditional distribution of the
latent "success" probability in the experimental condition given a
"success" probability of \code{p1} in the control condition),
\code{"rrisk"} (i.e., relative risk, the ratio of the "success" probability
in the experimental and the control condition), or \code{"arisk"} (i.e.,
absolute risk, the difference of the "success" probability in the
experimental and control condition).}

\item{hypothesis}{character specifying whether to evaluate the two-sided
prior density (i.e., "H1"), the one-sided prior density with lower
truncation point (i.e., "H+"), or the one-sided prior density with upper
truncation point (i.e., "H-").}
}
\value{
numeric vector with the values of the prior density.
}
\description{
Function for evaluating the prior density.
}
\note{
Internally, the test-relevant prior is always a normal prior on the log
  odds ratio, consequently, if \code{what} is not \code{"logor"}, the
  implied prior density for the quantity is returned.
}
\examples{
# prior parameters
prior_par <- list(mu_psi = 0, sigma_psi = 1,
                  mu_beta = 0, sigma_beta = 1)

# prior density
dprior(x1 = 0.1, prior_par = prior_par, what = "logor")
dprior(x1 = 1.1, prior_par = prior_par, what = "or")
dprior(x1 = 0.49, x2 = 0.51, prior_par = prior_par, what = "p1p2")
dprior(x1 = 0.45, prior_par = prior_par, what = "p1")
dprior(x1 = 0.45, prior_par = prior_par, what = "p2")
dprior(x1 = 0.49, x2 = 0.51, prior_par = prior_par, what = "p2givenp1")
dprior(x1 = 1.05, prior_par = prior_par, what = "rrisk")
dprior(x1 = 0.02, prior_par = prior_par, what = "arisk")

# also works for vectors
dprior(x1 = c(-0.1, 0, 0.1, 0.2), prior_par = prior_par, what = "logor")
}
\author{
Quentin F. Gronau
}
