% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_user_queryv2.R
\name{build_user_query}
\alias{build_user_query}
\title{Build tweet query}
\usage{
build_user_query(
  users,
  is_retweet = NULL,
  is_reply = FALSE,
  is_quote = FALSE,
  place = NULL,
  country = NULL,
  point_radius = NULL,
  bbox = NULL,
  geo_query = FALSE,
  remove_promoted = FALSE,
  has_hashtags = FALSE,
  has_cashtags = FALSE,
  has_links = FALSE,
  has_mentions = FALSE,
  has_media = FALSE,
  has_images = FALSE,
  has_videos = FALSE,
  has_geo = FALSE,
  lang = NULL
)
}
\arguments{
\item{users}{string or character vector, user handles from which to collect data}

\item{is_retweet}{If \code{TRUE}, only retweets will be returned; if \code{FALSE} retweets will not be returned}

\item{is_reply}{If \code{TRUE}, only reply tweets will be returned}

\item{is_quote}{If \code{TRUE}, only quote tweets will be returned}

\item{place}{string, name of place e.g. "London"}

\item{country}{string, name of country as ISO alpha-2 code e.g. "GB"}

\item{point_radius}{numeric, a vector of two point coordinates latitude, longitude, and point radius distance (in miles)}

\item{bbox}{numeric, a vector of four bounding box coordinates from west longitude to north latitude}

\item{geo_query}{If \code{TRUE} user will be prompted to enter relevant information for bounding box or point radius geo buffers}

\item{remove_promoted}{If \code{TRUE}, tweets created for promotion only on ads.twitter.com are removed}

\item{has_hashtags}{If \code{TRUE}, only tweets containing hashtags will be returned}

\item{has_cashtags}{If \code{TRUE}, only tweets containing cashtags will be returned}

\item{has_links}{If \code{TRUE}, only tweets containing links and media will be returned}

\item{has_mentions}{If \code{TRUE}, only tweets containing mentions will be returned}

\item{has_media}{If \code{TRUE}, only tweets containing a recognized media object, such as a photo, GIF, or video, as determined by Twitter will be returned}

\item{has_images}{If \code{TRUE}, only tweets containing a recognized URL to an image will be returned}

\item{has_videos}{If \code{TRUE}, only tweets containing contain native Twitter videos, uploaded directly to Twitter will be returned}

\item{has_geo}{If \code{TRUE}, only tweets containing Tweet-specific geolocation data provided by the Twitter user will be returned}

\item{lang}{string, a single BCP 47 language identifier e.g. "fr"}
}
\value{
a query string
}
\description{
Build tweet query according to targeted parameters, can then be input to main \code{\link{get_user_tweets}} function as query parameter.
}
\examples{
\dontrun{
users <- c("cbarrie", "justin_ct_ho")
query <-   build_user_query(users, is_retweet = F, has_media = T, lang = "en")
}

}
