% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{accept2}
\alias{accept2}
\title{Predicts COPD exacerbation rate by severity level based on the updated accept2 model, which improves accuracy in patients without an exacerbation history.}
\usage{
accept2(
  patientData,
  random_sampling_N = 100,
  lastYrExacCol = "LastYrExacCount",
  lastYrSevExacCol = "LastYrSevExacCount",
  KeepSGRQ = TRUE,
  KeepMeds = TRUE,
  ...
)
}
\arguments{
\item{patientData}{patient data matrix. Can have one or many patients in it}

\item{random_sampling_N}{number of random sampling. Default is 100.}

\item{lastYrExacCol}{the column specifying last year all exacerbation count}

\item{lastYrSevExacCol}{the column specifying last year severe exacerbation count}

\item{KeepSGRQ}{default is TRUE. If set to false, the reduced model without SGRQ will be used.}

\item{KeepMeds}{default is TRUE. If set to false, the reduced model without medication predictors will be used.}

\item{...}{for backward compatibility}
}
\value{
patientData with prediction
}
\description{
Predicts COPD exacerbation rate by severity level based on the updated accept2 model, which improves accuracy in patients without an exacerbation history.
}
\examples{
results <- accept2(samplePatients)
}
