% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_linear.R
\name{decay_linear}
\alias{decay_linear}
\title{Linear decay function}
\usage{
decay_linear(cutoff)
}
\arguments{
\item{cutoff}{A \code{numeric}. A number indicating the travel cost cutoff until
which the weighting factor decays linearly. From this point onward the
weight is equal to 0.}
}
\value{
A \code{function} that takes a generic travel cost vector (\code{numeric}) as
an input and returns a vector of weights (\code{numeric}).
}
\description{
Returns a linear weighting function to be used inside accessibility
calculating functions.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
weighting_function <- decay_linear(cutoff = 30)

weighting_function(20)

weighting_function(35)

}
\seealso{
Other decay functions: 
\code{\link{decay_binary}()},
\code{\link{decay_exponential}()},
\code{\link{decay_power}()},
\code{\link{decay_stepped}()}
}
\concept{decay functions}
