% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd2many.R
\name{rmd2many}
\alias{rmd2many}
\title{Create content in multiple formats}
\usage{
rmd2many(
  x,
  outputs = c("ioslides", "word"),
  slide_level = 1,
  css = "black",
  add18 = TRUE,
  pdf = TRUE,
  highlight = list(word = "monochrome", ioslides = NULL, slidy = NULL, html = NULL),
  params = NULL,
  zip = TRUE,
  ...
)
}
\arguments{
\item{x}{A character vector containing the names (\strong{no extension}) of
the \code{.Rmd} files to convert if they are in the current working
directory, or paths to the files, either absolute or relative to the
current working directory, e.g., \code{DIRECTORY/file1}.  The output
files are created in the same directory as their respective \code{.Rmd}
file.}

\item{outputs}{A character vector. Specifies the output formats required.
A subset of \code{c("word", "ioslides", "slidy", "html")}. If more than one of
\code{"ioslides"}, \code{"slidy"} and \code{"html"} are present then only
one of these is used with the order of preference \code{"ioslides"},
\code{"slidy"} then \code{"html"}.}

\item{slide_level}{Passed to \code{\link[=rmd2ioslides]{rmd2ioslides}} via
\code{...}. The default \code{slide_level = 1} means that a level one header #
create a new non-segue slide for an ioslides presentation.}

\item{css}{The argument \code{css} passed to
\code{\link[rmarkdown]{ioslides_presentation}} or
\code{\link[rmarkdown]{slidy_presentation}}. If \code{css = "black"}
then \code{accessr}'s css file \code{black.css} is used, which results in
black text being used in the slides.
\code{css} is not used if \code{outputs = html}.}

\item{add18}{A logical scalar. If \code{TRUE} then we also create Word documents
with 18pt text.}

\item{pdf}{A logical scalar. If \code{TRUE} then we use
\code{\link[pagedown:chrome_print]{chrome_print}} to print PDF versions of HTML
files produced using the output \code{"ioslides"} or \code{"slidy"}. and/or
\code{OfficeToPDF.exe} to create PDF files from any Word documents that
are produced.}

\item{highlight}{A named list, with names a subset of
\code{c("word", "ioslides", "slidy")}, providing the respective syntax
highlighting styles passed to Pandoc for the output formats. Any syntax
highlighting provided in \code{css} will take precedence.
\code{highlight} is not used if \code{outputs = html}.}

\item{params}{A list of named parameters to pass as the argument
\code{params} to \code{\link[rmarkdown]{render}}. In the example below,
the file \code{example.Rmd} has a parameter \code{hide}. If \code{hide = TRUE} then
parts of the output are hidden using the \code{knitr} chunk options \code{echo} and
\code{eval}.}

\item{zip}{A logical scalar or character vector indicating whether PDF
files should be put into a zip archive.  If \code{zip = FALSE} then no
zip archive is created.  Otherwise, an archive is created in each unique
directory involved in \code{x}.  If \code{zip = TRUE} then any archive
created is named after the first filename in \code{x} from the relevant
directory. If \code{zip} is a character vector of zip file names (no
extension) then these names are used to name the zip archives.  The names
are recycled to the length of the number of unique directories if
necessary.}

\item{...}{Additional arguments to be passed to
\code{\link[=rmd2ioslides]{rmd2ioslides}},
\code{\link[=rmd2slidy]{rmd2slidy}},
\code{\link[=rmd2word]{rmd2word}} or
\code{\link[=rmd2html]{rmd2html}}.}
}
\value{
A list containing the following components:
\item{files }{names of all the files created.}
\item{zips }{names of all zip files created (if \code{zip = TRUE}).}
}
\description{
From a single R markdown file create HTML slides, PDF slides, Word
and PDF documents.
}
\details{
The default setting creates, for each valid \code{filename} in \code{x}, the
following files
\itemize{
\item \code{filename.html}: lecture slides in \code{ioslides} format.
\item \code{filename_slides.pdf}: a PDF document containing the content in
\code{filename.html}.
\item \code{filename.pdf}: a PDF document created from a Word document produced by
\code{rmd2word}.
\item \code{filename.docx}: a Word document.
\item \code{filename18pt.docx}: a Word document. If \code{add18 = TRUE} then a template
Word document with 18pt bold text is used.
\item \code{filename.zip}: a zip file containing all the files produced.
}
}
\examples{
# Create documents from example.Rmd
got_hux <- requireNamespace("huxtable", quietly = TRUE)
got_flex <- requireNamespace("flextable", quietly = TRUE)
got_pandoc <- rmarkdown::pandoc_available("1.14")
got_all <- got_hux && got_flex && got_pandoc
# This example needs packages huxtable and flextable
# We pass pdf = FALSE because OfficeToPDF is needed to convert Word to PDF
# and this is only relevant on  Windows Operating System.
#
if (got_all) {
  ex_file <- system.file(package = "accessr", "examples", "example.Rmd")
  file.copy(ex_file, tdir <- tempdir(check = TRUE), overwrite = TRUE)
  ex_file <- list.files(tdir, pattern = "example.Rmd", full.names = TRUE)
  ex_file <- sub(".Rmd", "", ex_file)
  rmd2many(ex_file, params = list(hide = TRUE), pdf = FALSE, zip = TRUE)
}
}
\seealso{
\code{\link{install_otp}} to install
\href{https://github.com/cognidox/OfficeToPDF}{OfficeToPDF}.

\code{\link{rmd2word}}, \code{\link{rmd2ioslides}},
\code{\link{rmd2slidy}}, \code{\link{rmd2html}}.

The \href{https://paulnorthrop.github.io/accessr/}{accessr
package page on Github}.
}
