% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_data_delete_empty.R
\name{modify_data_delete_empty}
\alias{modify_data_delete_empty}
\title{Delete empty annotations}
\usage{
modify_data_delete_empty(
  x,
  trimBeforeCheck = FALSE,
  filterTiersInclude = "",
  filterTranscriptsInclude = ""
)
}
\arguments{
\item{x}{Corpus object.}

\item{trimBeforeCheck}{Logical; if \code{TRUE} leading and trailing spaces will be removed before checking (as a consequence record sets that contain only spaces will be deleted, too).}

\item{filterTiersInclude}{Character string; filter as a regular expression, which tiers should be processed.}

\item{filterTranscriptsInclude}{Character string; filter as a regular expression, which transcripts should be processed.}
}
\value{
Corpus object.
}
\description{
Delete empty annotations
}
\examples{
library(act)

# In the example corpus are no empty annotations.
# Empty annotations are deleted by default when annotation files are loaded.
# So let's first make an empty annotation.

# Check the first annotation in the first transcript
examplecorpus@transcripts[[1]]@data$content[[1]]

# Empty the contents of this annotation
examplecorpus@transcripts[[1]]@data$content[[1]] <- ""

# Run the function
test <- act::modify_data_delete_empty (x=examplecorpus)

# Compare how many data rows are in the first transcript in
# the example corpus and in the newly created test corpus:
nrow(examplecorpus@transcripts[[1]]@data)
nrow(test@transcripts[[1]]@data)

}
