% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_tiers_merge_tables.R
\name{helper_tiers_merge_tables}
\alias{helper_tiers_merge_tables}
\title{Helper: Merge tier tables}
\usage{
helper_tiers_merge_tables(...)
}
\arguments{
\item{...}{accepts different kinds of objects; transcript objects, lists of transcript objects (as in @transcripts of a corpus object) and tier tables (as in @tiers of a transcript object).}
}
\value{
Data.frame
}
\description{
Merges several the tier tables into one tier table.
}
\details{
NOTE: To actually modify the tiers in a transcript object or a corpus object corpus use the functions of the package, e.g. \code{act::transcripts_merge}.
This function is only a helper function and for people that like experiments.
If tiers with the same name are of different types ('IntervalTier', 'TextTier') an error will be raised.
In that case can use, for example,  'act::tier_convert()' to change the tier types.
}
\examples{
library(act)

# --- Create two tier tables from scratch
tierTable1 <-act::helper_tiers_new_table(c("a","b","c","d"),
c("IntervalTier", "TextTier","IntervalTier","TextTier"))

tierTable2 <-act::helper_tiers_new_table(c("a","b","x","y"),
c("IntervalTier", "TextTier","IntervalTier","TextTier"))

tierTable3 <- act::helper_tiers_merge_tables(tierTable1,tierTable2)
tierTable3

}
\seealso{
\link{helper_tiers_sort_table}, \link{helper_tiers_merge_tables}, \link{tiers_convert}, \link{tiers_rename}, \link{tiers_sort}, \link{transcripts_merge}
}
