% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_cure_single.R
\name{transcripts_cure_single}
\alias{transcripts_cure_single}
\title{Cure a single transcript}
\usage{
transcripts_cure_single(
  t,
  annotationsWithReversedTimes = TRUE,
  overlappingAnnotations = TRUE,
  annotationsWithTimesBelowZero = TRUE,
  missingTiers = TRUE,
  showWarning = FALSE
)
}
\arguments{
\item{t}{Transcript object.}

\item{annotationsWithReversedTimes}{Logical; If \code{TRUE} annotations with reversed times will be deleted}

\item{overlappingAnnotations}{Logical; If \code{TRUE} overlapping annotations will be corrected.}

\item{annotationsWithTimesBelowZero}{Logical; If \code{TRUE} annotations before 0 sec will be corrected.}

\item{missingTiers}{Logical; If \code{TRUE} tiers missing in \code{@tiers} slot of the transcript object will be added.}

\item{showWarning}{Logical; If \code{TRUE} a warning notice will be shown upon correction.}
}
\value{
Transcript object;
}
\description{
Transcript object may contain errors, e.g. because of defect annotation input files or user modifications.
This function may cure some of these errors.
- Annotations with reversed times: annotations with \code{endSec} lower than \code{startSec} will be deleted.
- Overlapping annotations: earlier annotations will end where the next annotation starts.
- Annotations below 0 sec: Annotations that are starting and ending before 0 sec will be deleted; Annotations starting before but ending after 0 sec will be truncated.
- Missing tiers: Tiers that are present in the annotations but missing in the list of tiers in \code{@tiers} of the transcript object will be added.
}
\examples{
library(act)

# --- annotationsWithReversedTimes: will be deleted
# get example transcript and reverse the times of an annotation
t <- examplecorpus@transcripts[[1]]
t@annotations$startSec[1] <- 20
t@annotations$endSec[1] <- 10
t2 <- act::transcripts_cure_single(t)
tail(t2@history, n=1)


# --- annotationsWithTimesBelowZero: will be deleted or start at 0 sec
t <- examplecorpus@transcripts[[1]]
t@annotations$startSec[1] <- -2
t@annotations$endSec[1]   <- -1
t2 <- act::transcripts_cure_single(t)
tail(t2@history, n=1)

t <- examplecorpus@transcripts[[1]]
t@annotations$startSec[2] <- -5
t2 <- act::transcripts_cure_single(t)
tail(t2@history, n=1)


# --- overlappingAnnotations: will end where the next starts
t<-examplecorpus@transcripts[[1]]
t@annotations <- t@annotations[order(t@annotations$tier.name, t@annotations$startSec), ]
t@annotations$endSec[1] <- 8
t2 <- act::transcripts_cure_single(t)
tail(t2@history, n=1)


# --- missingTiers: will be added to @tiers in transcript object
t<-examplecorpus@transcripts[[1]]
t@annotations <- t@annotations[order(t@annotations$tier.name, t@annotations$startSec), ]
t@annotations$tier.name[1] <- "NEW"
t2 <- act::transcripts_cure_single(t)
tail(t2@history, n=1)
t2@tiers
# compare with original tiers
t@tiers


# --- several things at once
t<-examplecorpus@transcripts[[1]]
t@annotations <- t@annotations[order(t@annotations$tier.name, t@annotations$startSec), ]
# annotation completely below 0 sec
t@annotations$startSec[1] <- -6
t@annotations$endSec[1]   <- -5
# annotation starts before but ends after 0 sec
t@annotations$startSec[2] <- -3
# annotation with reversed times
t@annotations$startSec[3] <- 6.9
t@annotations$endSec[3]   <- -6.8
# annotation overlaps with next annotation
t@annotations$endSec[6]   <- 9
# new tier, missing tier list
t@annotations$tier.name[8] <- "NEW"
t2 <- act::transcripts_cure_single(t, showWarning=TRUE)
tail(t2@history, n=1)


examplecorpus@transcripts[[1]]@history
}
\seealso{
\link{transcripts_cure}
}
