% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_corpus.R
\docType{class}
\name{corpus-class}
\alias{corpus-class}
\title{Corpus object}
\description{
This is the main object the act package uses. 
It collects the annotations and meta data from loaded annotation files.
}
\details{
Some of the slots are defined by the user.
Some slots report results, such as \code{@import.results} and \code{@history} and .
Other slots are settings and are used when performing functions on the corpus oibject.
To change the normalization matrix use \code{x@normalization.matrix <- act::matrix_load(path="...")}
}
\section{Slots}{

\describe{
\item{\code{name}}{Character string; Name of the corpus.}

\item{\code{transcripts}}{List of transcript objects; Each annotation file that has been load is stored in this list as a transcript object.}

\item{\code{paths.annotation.files}}{Vector of character strings; Path(s) to one or several folders where your annotation files are located.}

\item{\code{paths.media.files}}{Vector of character strings; Path(s) to one or several folders where your media files are located.}

\item{\code{import.skip.double.files}}{Logical; if \code{TRUE} files with the same names will be skipped (only one of them will be loaded), if \code{FALSE} transcripts will be renamed to make the names unique.}

\item{\code{import.modify.transcript.names}}{List; Options how to modify the names of the transcript objects when they are added to the corpus. These options are useful, for instacne, if your annotation files contain character sequences that you do not want to include into the transcript name in the corpus (e.g. if you regularly add a date to the file name of your annotations files  as 'myFile_2020-09-21.TextGrid').}

\item{\code{import.results}}{Data.frame; information about the import of the annotation files.}

\item{\code{normalization.matrix}}{Data.frame; Replacement matrix used for normalizing the annotations.}

\item{\code{history}}{List; History of modifications made by any of the package functions to the corpus.}
}}

\examples{
library(act)

examplecorpus

}
