% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residency.R
\name{res_efficiency}
\alias{res_efficiency}
\title{Calculate array efficiency for residency analysis}
\usage{
res_efficiency(arrmoves, bio, spatial, arrays, paths, dotmat)
}
\arguments{
\item{arrmoves}{the array movements}

\item{bio}{A table with the tags and biometrics of the studied fish.}

\item{spatial}{A list of spatial objects in the study area}

\item{arrays}{a list containing information for each array}

\item{paths}{a list containing the shortest paths between arrays with distance > 1}

\item{dotmat}{A dot distance matrix}
}
\value{
A list containing:
\itemize{
\item \code{absolutes}: A data frame with the number of fish detected and missed at each array.
\item \code{max.efficiency}: A vector of efficiency values calculated disregarding potentially missed fish.
\item \code{min.efficiency}: A vector of efficiency values calculated taking into account potentially missed fish.
\item \code{values.per.fish}: A list containing details on the arrays that have failed for each fish.
}
}
\description{
Calculate array efficiency for residency analysis
}
\keyword{internal}
