% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotMoves}
\alias{plotMoves}
\title{Plot moves for one ore more tags}
\usage{
plotMoves(
  input,
  tags,
  title,
  xlab,
  ylab,
  col,
  array.alias,
  show.release = TRUE
)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{tags}{The transmitters to be plotted (optional).}

\item{title}{An optional title for the plot.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{col}{An optional colour scheme for the detections. If left empty, default colours will be added.}

\item{array.alias}{A named vector of format c("old_array_name" = "new_array_name") to replace
default array names with user defined ones.}

\item{show.release}{Logical: Should the line from release to first detection be displayed?}
}
\value{
A ggplot object.
}
\description{
The output of plotMoves is a ggplot object, which means you can then use it in combination
with other ggplot functions, or even together with other packages such as patchwork.
}
\examples{
# Using the example results that come with actel
plotMoves(example.results, 'R64K-4451')

# Because plotMoves returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotMoves(example.results, 'R64K-4451')
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
