% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preload.R
\name{preload}
\alias{preload}
\title{Load a dataset before running an analysis}
\usage{
preload(
  biometrics,
  spatial,
  deployments,
  detections,
  dot,
  distances,
  tz,
  start.time = NULL,
  stop.time = NULL,
  section.order = NULL,
  exclude.tags = NULL,
  disregard.parallels = FALSE,
  discard.orphans = FALSE
)
}
\arguments{
\item{biometrics}{A data frame containing biometric information.}

\item{spatial}{A data frame containing spatial information.}

\item{deployments}{A data frame containing deployment information.}

\item{detections}{A data frame containing the detections.}

\item{dot}{A DOT string of the array configuration.}

\item{distances}{A distances matrix between arrays. See \code{\link{distancesMatrix}}.}

\item{tz}{The time zone of the study area. Must match one of the values
present in \code{\link[base]{timezones}}.}

\item{start.time}{Detection data prior to the timestamp set in
\code{start.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{stop.time}{Detection data posterior to the timestamp set in
\code{stop.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{section.order}{A vector containing the order by which sections should
be aligned in the results.}

\item{exclude.tags}{A vector of tags that should be excluded from the
detection data before any analyses are performed. Intended to be used if
stray tags from a different code space but with the same signal as a target
tag are detected in the study area.}

\item{disregard.parallels}{Logical:  Should the presence of parallel arrays
invalidate potential efficiency peers? See the vignettes for more details.}

\item{discard.orphans}{Logical: Should actel automatically discard
detections that do not fall within receiver deployment periods, or that
were recorded before the respective animals were released?}
}
\value{
A dataset that can be used as an input for actel's main analyses.
This dataset contains:
\itemize{
\item \code{bio}: The biometric data
\item \code{sections}: The sections of the study area, if set using the argument sections (required to run residency and migration analyses)
\item \code{deployments}: The deployment data
\item \code{spatial}: The spatial data, split in stations and release sites.
\item \code{dot}: A table of array connections.
\item \code{arrays}: A list with the details of each array
\item \code{dotmat}: A matrix of distances between arrays (in number of arrays).
\item \code{dist.mat}: The distances matrix.
\item \code{detections.list}: A processed list of detections for each tag.
\item \code{paths}: A list of the possible paths between each pair of arrays.
\item \code{disregard.parallels}: Logical: Should parallel arrays invalidate efficiency peers? (required to run residency and migration analyses)
\item \code{tz}: The time zone of the study area
}
}
\description{
This function allows the user to prepare a set of R objects to be run through
an \code{\link{explore}}, \code{\link{migration}} or \code{\link{residency}}
analysis.
}
\examples{
# This function requires a series of pre-created R objects.
# We can create them by loading the example files from actel:
aux <- system.file(package = "actel")[1]

bio <- read.csv(paste0(aux, "/example_biometrics.csv"))
deployments <- read.csv(paste0(aux, "/example_deployments.csv"))
spatial <- read.csv(paste0(aux, "/example_spatial.csv"))
detections <- read.csv(paste0(aux, "/example_detections.csv"))

dot <- "A0--A1--A2--A3--A4--A5--A6--A7--A8--A9"

# Now that we have the R objects created, we can run preload:

x <- preload(biometrics = bio, deployments = deployments, spatial = spatial,
 detections = detections, dot = dot, tz = "Europe/Copenhagen")


}
